"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryHitRT = exports.getSortDirection = exports.getLogEntriesResponseRT = exports.createGetLogEntriesQuery = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_entry = require("../../../../common/log_entry");
var _typed_json = require("../../../../common/typed_json");
var _elasticsearch_runtime_types = require("../../../utils/elasticsearch_runtime_types");
var _common = require("./common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetLogEntriesQuery = (logEntriesIndex, startTimestamp, endTimestamp, cursor, size, timestampField, tiebreakerField, fields, runtimeMappings, query, highlightTerm) => {
  const sortDirection = getSortDirection(cursor);
  const highlightQuery = createHighlightQuery(highlightTerm, fields);
  return {
    index: logEntriesIndex,
    allow_no_indices: true,
    track_scores: false,
    track_total_hits: false,
    body: {
      size,
      query: {
        bool: {
          filter: [...(query ? [query] : []), ...(highlightQuery ? [highlightQuery] : []), ...(0, _common.createTimeRangeFilterClauses)(startTimestamp, endTimestamp, timestampField)]
        }
      },
      fields,
      runtime_mappings: runtimeMappings,
      _source: false,
      ...(0, _common.createSortClause)(sortDirection, timestampField, tiebreakerField),
      ...createSearchAfterClause(cursor),
      ...createHighlightClause(highlightQuery, fields)
    }
  };
};
exports.createGetLogEntriesQuery = createGetLogEntriesQuery;
const getSortDirection = cursor => _log_entry.logEntryBeforeCursorRT.is(cursor) ? 'desc' : 'asc';
exports.getSortDirection = getSortDirection;
const createSearchAfterClause = cursor => {
  if (_log_entry.logEntryBeforeCursorRT.is(cursor) && cursor.before !== 'last') {
    return {
      search_after: [cursor.before.time, cursor.before.tiebreaker]
    };
  } else if (_log_entry.logEntryAfterCursorRT.is(cursor) && cursor.after !== 'first') {
    return {
      search_after: [cursor.after.time, cursor.after.tiebreaker]
    };
  }
  return {};
};
const createHighlightClause = (highlightQuery, fields) => highlightQuery ? {
  highlight: {
    boundary_scanner: 'word',
    fields: fields.reduce((highlightFieldConfigs, fieldName) => ({
      ...highlightFieldConfigs,
      [fieldName]: {}
    }), {}),
    fragment_size: 1,
    number_of_fragments: 100,
    post_tags: [''],
    pre_tags: [''],
    highlight_query: highlightQuery
  }
} : {};
const createHighlightQuery = (highlightTerm, fields) => {
  if (highlightTerm) {
    return {
      multi_match: {
        fields,
        lenient: true,
        query: highlightTerm,
        type: 'phrase'
      }
    };
  }
};
const logEntryHitRT = exports.logEntryHitRT = rt.intersection([_elasticsearch_runtime_types.commonHitFieldsRT, rt.type({
  sort: rt.tuple([rt.number, rt.number])
}), rt.partial({
  fields: rt.record(rt.string, _typed_json.jsonArrayRT),
  highlight: rt.record(rt.string, rt.array(rt.string))
})]);
const getLogEntriesResponseRT = exports.getLogEntriesResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  hits: rt.type({
    hits: rt.array(logEntryHitRT)
  })
})]);