"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntrySearchStrategyProvider = exports.logEntrySearchRequestStateRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _log_entry = require("../../../common/log_entry");
var _runtime_types = require("../../../common/runtime_types");
var _log_entry2 = require("../../../common/search_strategies/log_entries/log_entry");
var _typed_search_strategy = require("../../utils/typed_search_strategy");
var _log_entry3 = require("./queries/log_entry");
var _log_sources = require("../../../common/log_sources");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logEntrySearchStrategyProvider = ({
  data,
  sources
}) => {
  const esSearchStrategy = data.search.getSearchStrategy('ese');
  return {
    search: (rawRequest, options, dependencies) => (0, _rxjs.defer)(() => {
      const request = (0, _runtime_types.decodeOrThrow)(asyncRequestRT)(rawRequest);
      const resolvedSourceConfiguration$ = (0, _rxjs.defer)(() => (0, _rxjs.forkJoin)([sources.getSourceConfiguration(dependencies.savedObjectsClient, request.params.sourceId), data.indexPatterns.indexPatternsServiceFactory(dependencies.savedObjectsClient, dependencies.esClient.asCurrentUser)]).pipe((0, _operators.concatMap)(([sourceConfiguration, indexPatternsService]) => (0, _log_sources.resolveLogSourceConfiguration)(sourceConfiguration.configuration, indexPatternsService)))).pipe((0, _operators.take)(1), (0, _operators.shareReplay)(1));
      const recoveredRequest$ = (0, _rxjs.of)(request).pipe((0, _operators.filter)(asyncRecoveredRequestRT.is), (0, _operators.map)(({
        id: {
          esRequestId
        }
      }) => ({
        id: esRequestId
      })));
      const initialRequest$ = (0, _rxjs.of)(request).pipe((0, _operators.filter)(asyncInitialRequestRT.is), (0, _operators.concatMap)(({
        params
      }) => resolvedSourceConfiguration$.pipe((0, _operators.map)(({
        indices,
        timestampField,
        tiebreakerField,
        runtimeMappings
      }) => ({
        params: (0, _log_entry3.createGetLogEntryQuery)(indices, params.logEntryId, timestampField, tiebreakerField, runtimeMappings)
      })))));
      return (0, _rxjs.concat)(recoveredRequest$, initialRequest$).pipe((0, _operators.take)(1), (0, _operators.concatMap)(esRequest => esSearchStrategy.search(esRequest, options, dependencies)), (0, _operators.map)(esResponse => ({
        ...esResponse,
        rawResponse: (0, _runtime_types.decodeOrThrow)(_log_entry3.getLogEntryResponseRT)(esResponse.rawResponse)
      })), (0, _operators.map)(esResponse => {
        var _esResponse$rawRespon, _esResponse$rawRespon2;
        return {
          ...esResponse,
          ...(esResponse.id ? {
            id: logEntrySearchRequestStateRT.encode({
              esRequestId: esResponse.id
            })
          } : {}),
          rawResponse: _log_entry2.logEntrySearchResponsePayloadRT.encode({
            data: (_esResponse$rawRespon = esResponse.rawResponse.hits.hits.map(createLogEntryFromHit)[0]) !== null && _esResponse$rawRespon !== void 0 ? _esResponse$rawRespon : null,
            errors: ((_esResponse$rawRespon2 = esResponse.rawResponse._shards.failures) !== null && _esResponse$rawRespon2 !== void 0 ? _esResponse$rawRespon2 : []).map(_typed_search_strategy.createErrorFromShardFailure)
          })
        };
      }));
    }),
    cancel: async (id, options, dependencies) => {
      var _esSearchStrategy$can;
      const {
        esRequestId
      } = (0, _runtime_types.decodeOrThrow)(logEntrySearchRequestStateRT)(id);
      return await ((_esSearchStrategy$can = esSearchStrategy.cancel) === null || _esSearchStrategy$can === void 0 ? void 0 : _esSearchStrategy$can.call(esSearchStrategy, esRequestId, options, dependencies));
    }
  };
};

// exported for tests
exports.logEntrySearchStrategyProvider = logEntrySearchStrategyProvider;
const logEntrySearchRequestStateRT = exports.logEntrySearchRequestStateRT = rt.string.pipe(_typed_search_strategy.jsonFromBase64StringRT).pipe(rt.type({
  esRequestId: rt.string
}));
const {
  asyncInitialRequestRT,
  asyncRecoveredRequestRT,
  asyncRequestRT
} = (0, _typed_search_strategy.createAsyncRequestRTs)(logEntrySearchRequestStateRT, _log_entry2.logEntrySearchRequestParamsRT);
const createLogEntryFromHit = hit => {
  var _hit$fields;
  return {
    id: hit._id,
    index: hit._index,
    cursor: (0, _log_entry.getLogEntryCursorFromHit)(hit),
    fields: Object.entries((_hit$fields = hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {}).map(([field, value]) => ({
      field,
      value
    }))
  };
};