"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partialMetricsSourceConfigurationReqPayloadRT = exports.partialMetricsSourceConfigurationPropertiesRT = exports.metricsSourceStatusRT = exports.metricsSourceConfigurationResponseRT = exports.metricsSourceConfigurationRT = exports.metricsSourceConfigurationPropertiesRT = void 0;
var _index_pattern_rt = require("@kbn/io-ts-utils/index_pattern_rt");
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _source_configuration = require("../source_configuration/source_configuration");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Properties specific to the Metrics Source Configuration.
 */
const metricsSourceConfigurationPropertiesRT = exports.metricsSourceConfigurationPropertiesRT = rt.strict({
  name: _source_configuration.SourceConfigurationRT.props.name,
  description: _source_configuration.SourceConfigurationRT.props.description,
  metricAlias: _source_configuration.SourceConfigurationRT.props.metricAlias,
  inventoryDefaultView: _source_configuration.SourceConfigurationRT.props.inventoryDefaultView,
  metricsExplorerDefaultView: _source_configuration.SourceConfigurationRT.props.metricsExplorerDefaultView,
  fields: rt.strict((0, _lodash.omit)(_source_configuration.SourceConfigurationRT.props.fields.props, 'message')),
  anomalyThreshold: rt.number
});
const partialMetricsSourceConfigurationReqPayloadRT = exports.partialMetricsSourceConfigurationReqPayloadRT = rt.partial({
  ...metricsSourceConfigurationPropertiesRT.type.props,
  metricAlias: _index_pattern_rt.indexPatternRt,
  fields: rt.partial({
    ...metricsSourceConfigurationPropertiesRT.type.props.fields.type.props
  })
});
const partialMetricsSourceConfigurationPropertiesRT = exports.partialMetricsSourceConfigurationPropertiesRT = rt.partial({
  ...metricsSourceConfigurationPropertiesRT.type.props,
  fields: rt.partial({
    ...metricsSourceConfigurationPropertiesRT.type.props.fields.type.props
  })
});
const metricsSourceConfigurationOriginRT = rt.keyof({
  fallback: null,
  internal: null,
  stored: null
});
const metricsSourceStatusRT = exports.metricsSourceStatusRT = rt.strict({
  metricIndicesExist: _source_configuration.SourceStatusRuntimeType.props.metricIndicesExist,
  indexFields: _source_configuration.SourceStatusRuntimeType.props.indexFields
});
const metricsSourceConfigurationRT = exports.metricsSourceConfigurationRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  origin: metricsSourceConfigurationOriginRT,
  configuration: metricsSourceConfigurationPropertiesRT
}), rt.partial({
  updatedAt: rt.number,
  version: rt.string,
  status: metricsSourceStatusRT
})]));
const metricsSourceConfigurationResponseRT = exports.metricsSourceConfigurationResponseRT = rt.type({
  source: metricsSourceConfigurationRT
});