"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containerOverview = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerOverview = (timeField, indexPattern, interval) => ({
  id: 'containerOverview',
  requires: ['docker'],
  index_pattern: indexPattern,
  interval,
  time_field: timeField,
  type: 'timeseries',
  series: [{
    id: 'cpu',
    split_mode: 'everything',
    metrics: [{
      field: 'docker.cpu.total.pct',
      id: 'avg-cpu-total',
      type: 'avg'
    }]
  }, {
    id: 'memory',
    split_mode: 'everything',
    metrics: [{
      field: 'docker.memory.usage.pct',
      id: 'avg-memory',
      type: 'avg'
    }]
  }, {
    id: 'tx',
    split_mode: 'everything',
    metrics: [{
      field: 'docker.network.out.bytes',
      id: 'avg-network-out',
      type: 'avg'
    }]
  }, {
    id: 'rx',
    split_mode: 'everything',
    metrics: [{
      field: 'docker.network.in.bytes',
      id: 'avg-network-in',
      type: 'avg'
    }]
  }]
});
exports.containerOverview = containerOverview;