"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntriesHighlightsResponseRT = exports.logEntriesHighlightsRequestRT = exports.logEntriesHighlightsCenteredRequestRT = exports.logEntriesHighlightsBeforeRequestRT = exports.logEntriesHighlightsBaseRequestRT = exports.logEntriesHighlightsAfterRequestRT = exports.LOG_ENTRIES_HIGHLIGHTS_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_entry = require("../../log_entry");
var _log_source_configuration = require("../../log_sources/log_source_configuration");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ENTRIES_HIGHLIGHTS_PATH = exports.LOG_ENTRIES_HIGHLIGHTS_PATH = '/api/log_entries/highlights';
const logEntriesHighlightsBaseRequestRT = exports.logEntriesHighlightsBaseRequestRT = rt.intersection([rt.type({
  sourceId: rt.string,
  startTimestamp: rt.number,
  endTimestamp: rt.number,
  highlightTerms: rt.array(rt.string)
}), rt.partial({
  query: rt.union([rt.string, rt.null]),
  size: rt.number,
  columns: rt.array(_log_source_configuration.logSourceColumnConfigurationRT)
})]);
const logEntriesHighlightsBeforeRequestRT = exports.logEntriesHighlightsBeforeRequestRT = rt.intersection([logEntriesHighlightsBaseRequestRT, rt.type({
  before: rt.union([_log_entry.logEntryCursorRT, rt.literal('last')])
})]);
const logEntriesHighlightsAfterRequestRT = exports.logEntriesHighlightsAfterRequestRT = rt.intersection([logEntriesHighlightsBaseRequestRT, rt.type({
  after: rt.union([_log_entry.logEntryCursorRT, rt.literal('first')])
})]);
const logEntriesHighlightsCenteredRequestRT = exports.logEntriesHighlightsCenteredRequestRT = rt.intersection([logEntriesHighlightsBaseRequestRT, rt.type({
  center: _log_entry.logEntryCursorRT
})]);
const logEntriesHighlightsRequestRT = exports.logEntriesHighlightsRequestRT = rt.union([logEntriesHighlightsBaseRequestRT, logEntriesHighlightsBeforeRequestRT, logEntriesHighlightsAfterRequestRT, logEntriesHighlightsCenteredRequestRT]);
const logEntriesHighlightsResponseRT = exports.logEntriesHighlightsResponseRT = rt.type({
  data: rt.array(rt.union([rt.type({
    topCursor: rt.null,
    bottomCursor: rt.null,
    entries: rt.array(_log_entry.logEntryRT)
  }), rt.type({
    topCursor: _log_entry.logEntryCursorRT,
    bottomCursor: _log_entry.logEntryCursorRT,
    entries: rt.array(_log_entry.logEntryRT)
  })]))
});