"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogEntryCategoryExamplesSuccessReponsePayloadRT = exports.getLogEntryCategoryExamplesResponsePayloadRT = exports.getLogEntryCategoryExamplesRequestPayloadRT = exports.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORY_EXAMPLES_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _shared = require("../../shared");
var _log_entry = require("../../../log_entry");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORY_EXAMPLES_PATH = exports.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORY_EXAMPLES_PATH = '/api/infra/log_analysis/results/log_entry_category_examples';

/**
 * request
 */

const getLogEntryCategoryExamplesRequestPayloadRT = exports.getLogEntryCategoryExamplesRequestPayloadRT = rt.type({
  data: rt.type({
    // the category to fetch the examples for
    categoryId: rt.number,
    // the number of examples to fetch
    exampleCount: rt.number,
    // the id of the source configuration
    sourceId: rt.string,
    // the time range to fetch the category examples from
    timeRange: _shared.timeRangeRT
  })
});
/**
 * response
 */

const logEntryCategoryExampleRT = rt.type({
  id: rt.string,
  dataset: rt.string,
  message: rt.string,
  timestamp: rt.number,
  tiebreaker: rt.number,
  context: _log_entry.logEntryContextRT
});
const getLogEntryCategoryExamplesSuccessReponsePayloadRT = exports.getLogEntryCategoryExamplesSuccessReponsePayloadRT = rt.intersection([rt.type({
  data: rt.type({
    examples: rt.array(logEntryCategoryExampleRT)
  })
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);
const getLogEntryCategoryExamplesResponsePayloadRT = exports.getLogEntryCategoryExamplesResponsePayloadRT = rt.union([getLogEntryCategoryExamplesSuccessReponsePayloadRT, _shared.badRequestErrorRT, _shared.forbiddenErrorRT]);