"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureTitle = exports.featureId = exports.applicationPath = exports.UI_SETTING_MAX_FILE_SIZE = exports.OMIT_FIELDS = exports.NON_AGGREGATABLE_FIELD_TYPES = exports.MB = exports.MAX_FILE_SIZE_BYTES = exports.MAX_FILE_SIZE = exports.JOB_FIELD_TYPES = exports.INDEX_META_DATA_CREATED_BY = exports.FILE_SIZE_DISPLAY_FORMAT = exports.FILE_DATA_VIS_TAB_ID = exports.ABSOLUTE_MAX_FILE_SIZE_BYTES = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("../../../../src/plugins/data/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UI_SETTING_MAX_FILE_SIZE = exports.UI_SETTING_MAX_FILE_SIZE = 'fileUpload:maxFileSize';
const MB = exports.MB = Math.pow(2, 20);
const MAX_FILE_SIZE = exports.MAX_FILE_SIZE = '100MB';
const MAX_FILE_SIZE_BYTES = exports.MAX_FILE_SIZE_BYTES = 104857600; // 100MB

const ABSOLUTE_MAX_FILE_SIZE_BYTES = exports.ABSOLUTE_MAX_FILE_SIZE_BYTES = 1073741274; // 1GB
const FILE_SIZE_DISPLAY_FORMAT = exports.FILE_SIZE_DISPLAY_FORMAT = '0,0.[0] b';

// Value to use in the Elasticsearch index mapping meta data to identify the
// index as having been created by the File Data Visualizer.
const INDEX_META_DATA_CREATED_BY = exports.INDEX_META_DATA_CREATED_BY = 'file-data-visualizer';
const JOB_FIELD_TYPES = exports.JOB_FIELD_TYPES = {
  BOOLEAN: 'boolean',
  DATE: 'date',
  GEO_POINT: 'geo_point',
  GEO_SHAPE: 'geo_shape',
  IP: 'ip',
  KEYWORD: 'keyword',
  NUMBER: 'number',
  TEXT: 'text',
  HISTOGRAM: 'histogram',
  UNKNOWN: 'unknown'
};
const OMIT_FIELDS = exports.OMIT_FIELDS = ['_source', '_type', '_index', '_id', '_version', '_score'];
const NON_AGGREGATABLE_FIELD_TYPES = exports.NON_AGGREGATABLE_FIELD_TYPES = new Set([_common.KBN_FIELD_TYPES.GEO_SHAPE, _common.KBN_FIELD_TYPES.HISTOGRAM]);
const FILE_DATA_VIS_TAB_ID = exports.FILE_DATA_VIS_TAB_ID = 'fileDataViz';
const applicationPath = exports.applicationPath = `/app/home#/tutorial_directory/${FILE_DATA_VIS_TAB_ID}`;
const featureTitle = exports.featureTitle = _i18n.i18n.translate('xpack.dataVisualizer.title', {
  defaultMessage: 'Upload a file'
});
const featureId = exports.featureId = `file_data_visualizer`;