"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetConfigureFindRequestRt = exports.CasesConfigureRequestRt = exports.CasesConfigurePatchRt = exports.CaseConfigureResponseRt = exports.CaseConfigureRequestParamsRt = exports.CaseConfigureAttributesRt = exports.CaseConfigurationsResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _user = require("../user");
var _connectors = require("../connectors");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: we will need to add this type rt.literal('close-by-third-party')
const ClosureTypeRT = rt.union([rt.literal('close-by-user'), rt.literal('close-by-pushing')]);
const CasesConfigureBasicWithoutOwnerRt = rt.type({
  /**
   * The external connector
   */
  connector: _connectors.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: ClosureTypeRT
});
const CasesConfigureBasicRt = rt.intersection([CasesConfigureBasicWithoutOwnerRt, rt.type({
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
})]);
const CasesConfigureRequestRt = exports.CasesConfigureRequestRt = CasesConfigureBasicRt;
const CasesConfigurePatchRt = exports.CasesConfigurePatchRt = rt.intersection([rt.partial(CasesConfigureBasicWithoutOwnerRt.props), rt.type({
  version: rt.string
})]);
const CaseConfigureAttributesRt = exports.CaseConfigureAttributesRt = rt.intersection([CasesConfigureBasicRt, rt.type({
  created_at: rt.string,
  created_by: _user.UserRT,
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_user.UserRT, rt.null])
})]);
const CaseConfigureResponseRt = exports.CaseConfigureResponseRt = rt.intersection([CaseConfigureAttributesRt, _connectors.ConnectorMappingsRt, rt.type({
  id: rt.string,
  version: rt.string,
  error: rt.union([rt.string, rt.null]),
  owner: rt.string
})]);
const GetConfigureFindRequestRt = exports.GetConfigureFindRequestRt = rt.partial({
  /**
   * The configuration plugin owner to filter the search by. If this is left empty the results will include all configurations
   * that the user has permissions to access
   */
  owner: rt.union([rt.array(rt.string), rt.string])
});
const CaseConfigureRequestParamsRt = exports.CaseConfigureRequestParamsRt = rt.type({
  configuration_id: rt.string
});
const CaseConfigurationsResponseRt = exports.CaseConfigurationsResponseRt = rt.array(CaseConfigureResponseRt);