"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindQueryParamsRt = exports.ContextTypeUserRt = exports.CommentsResponseRt = exports.CommentType = exports.CommentResponseTypeAlertsRt = exports.CommentResponseTypeActionsRt = exports.CommentResponseRt = exports.CommentRequestRt = exports.CommentPatchRequestRt = exports.CommentPatchAttributesRt = exports.CommentAttributesBasicRt = exports.AssociationType = exports.AllCommentsResponseRt = exports.AllCommentsResponseRT = exports.AlertCommentRequestRt = exports.ActionsCommentRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _saved_object = require("../saved_object");
var _user = require("../user");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * this is used to differentiate between an alert attached to a top-level case and a group of alerts that should only
 * be attached to a sub case. The reason we need this is because an alert group comment will have references to both a case and
 * sub case when it is created. For us to be able to filter out alert groups in a top-level case we need a field to
 * use as a filter.
 */
let AssociationType = exports.AssociationType = /*#__PURE__*/function (AssociationType) {
  AssociationType["case"] = "case";
  AssociationType["subCase"] = "sub_case";
  return AssociationType;
}({});
const CommentAttributesBasicRt = exports.CommentAttributesBasicRt = rt.type({
  associationType: rt.union([rt.literal(AssociationType.case), rt.literal(AssociationType.subCase)]),
  created_at: rt.string,
  created_by: _user.UserRT,
  owner: rt.string,
  pushed_at: rt.union([rt.string, rt.null]),
  pushed_by: rt.union([_user.UserRT, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_user.UserRT, rt.null])
});
let CommentType = exports.CommentType = /*#__PURE__*/function (CommentType) {
  CommentType["user"] = "user";
  CommentType["alert"] = "alert";
  CommentType["generatedAlert"] = "generated_alert";
  CommentType["actions"] = "actions";
  return CommentType;
}({});
const ContextTypeUserRt = exports.ContextTypeUserRt = rt.type({
  comment: rt.string,
  type: rt.literal(CommentType.user),
  owner: rt.string
});

/**
 * This defines the structure of how alerts (generated or user attached) are stored in saved objects documents. It also
 * represents of an alert after it has been transformed. A generated alert will be transformed by the connector so that
 * it matches this structure. User attached alerts do not need to be transformed.
 */
const AlertCommentRequestRt = exports.AlertCommentRequestRt = rt.type({
  type: rt.union([rt.literal(CommentType.generatedAlert), rt.literal(CommentType.alert)]),
  alertId: rt.union([rt.array(rt.string), rt.string]),
  index: rt.union([rt.array(rt.string), rt.string]),
  rule: rt.type({
    id: rt.union([rt.string, rt.null]),
    name: rt.union([rt.string, rt.null])
  }),
  owner: rt.string
});
const ActionsCommentRequestRt = exports.ActionsCommentRequestRt = rt.type({
  type: rt.literal(CommentType.actions),
  comment: rt.string,
  actions: rt.type({
    targets: rt.array(rt.type({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
});
const AttributesTypeUserRt = rt.intersection([ContextTypeUserRt, CommentAttributesBasicRt]);
const AttributesTypeAlertsRt = rt.intersection([AlertCommentRequestRt, CommentAttributesBasicRt]);
const AttributesTypeActionsRt = rt.intersection([ActionsCommentRequestRt, CommentAttributesBasicRt]);
const CommentAttributesRt = rt.union([AttributesTypeUserRt, AttributesTypeAlertsRt, AttributesTypeActionsRt]);
const CommentRequestRt = exports.CommentRequestRt = rt.union([ContextTypeUserRt, AlertCommentRequestRt, ActionsCommentRequestRt]);
const CommentResponseRt = exports.CommentResponseRt = rt.intersection([CommentAttributesRt, rt.type({
  id: rt.string,
  version: rt.string
})]);
const CommentResponseTypeAlertsRt = exports.CommentResponseTypeAlertsRt = rt.intersection([AttributesTypeAlertsRt, rt.type({
  id: rt.string,
  version: rt.string
})]);
const CommentResponseTypeActionsRt = exports.CommentResponseTypeActionsRt = rt.intersection([AttributesTypeActionsRt, rt.type({
  id: rt.string,
  version: rt.string
})]);
const AllCommentsResponseRT = exports.AllCommentsResponseRT = rt.array(CommentResponseRt);
const CommentPatchRequestRt = exports.CommentPatchRequestRt = rt.intersection([
/**
 * Partial updates are not allowed.
 * We want to prevent the user for changing the type without removing invalid fields.
 */
CommentRequestRt, rt.type({
  id: rt.string,
  version: rt.string
})]);

/**
 * This type is used by the CaseService.
 * Because the type for the attributes of savedObjectClient update function is Partial<T>
 * we need to make all of our attributes partial too.
 * We ensure that partial updates of CommentContext is not going to happen inside the patch comment route.
 */
const CommentPatchAttributesRt = exports.CommentPatchAttributesRt = rt.intersection([rt.union([rt.partial(CommentAttributesBasicRt.props), rt.partial(AlertCommentRequestRt.props)]), rt.partial(CommentAttributesBasicRt.props)]);
const CommentsResponseRt = exports.CommentsResponseRt = rt.type({
  comments: rt.array(CommentResponseRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
});
const AllCommentsResponseRt = exports.AllCommentsResponseRt = rt.array(CommentResponseRt);
const FindQueryParamsRt = exports.FindQueryParamsRt = rt.partial({
  ..._saved_object.SavedObjectFindOptionsRt.props,
  /**
   * If specified the attachments found will be associated to a sub case instead of a case object
   */
  subCaseId: rt.string
});