"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthStatus = exports.AlertExecutionStatusValues = exports.AlertExecutionStatusErrorReasons = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// for the `typeof ThingValues[number]` types below, become string types that
// only accept the values in the associated string arrays
const AlertExecutionStatusValues = exports.AlertExecutionStatusValues = ['ok', 'active', 'error', 'pending', 'unknown'];
let AlertExecutionStatusErrorReasons = exports.AlertExecutionStatusErrorReasons = /*#__PURE__*/function (AlertExecutionStatusErrorReasons) {
  AlertExecutionStatusErrorReasons["Read"] = "read";
  AlertExecutionStatusErrorReasons["Decrypt"] = "decrypt";
  AlertExecutionStatusErrorReasons["Execute"] = "execute";
  AlertExecutionStatusErrorReasons["Unknown"] = "unknown";
  AlertExecutionStatusErrorReasons["License"] = "license";
  return AlertExecutionStatusErrorReasons;
}({});
let HealthStatus = exports.HealthStatus = /*#__PURE__*/function (HealthStatus) {
  HealthStatus["OK"] = "ok";
  HealthStatus["Warning"] = "warn";
  HealthStatus["Error"] = "error";
  return HealthStatus;
}({});