"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterHeaders = filterHeaders;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Converts an object type to a new object type where each string
 * key is copied to the values of the object, and non string keys are
 * given a `never` value. This allows us to map over the values and
 * get the list of all string keys on a type in `KnownKeys<T>`
 */

/**
 * Creates a Union type of all known keys of a given interface.
 * @example
 * ```ts
 * interface Person {
 *   name: string;
 *   age: number;
 *   [attributes: string]: string | number;
 * }
 * type PersonKnownKeys = KnownKeys<Person>; // "age" | "name"
 * ```
 */

/**
 * Set of well-known HTTP headers.
 * @public
 */

/**
 * Http request headers to read.
 * @public
 */

/**
 * Http response headers to set.
 * @public
 */

const normalizeHeaderField = field => field.trim().toLowerCase();
function filterHeaders(headers, fieldsToKeep, fieldsToExclude = []) {
  const fieldsToExcludeNormalized = fieldsToExclude.map(normalizeHeaderField);
  // Normalize list of headers we want to allow in upstream request
  const fieldsToKeepNormalized = fieldsToKeep.map(normalizeHeaderField).filter(name => !fieldsToExcludeNormalized.includes(name));
  return (0, _std.pick)(headers, fieldsToKeepNormalized);
}