"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esVersionCompatibleWithKibana = esVersionCompatibleWithKibana;
exports.esVersionEqualsKibana = esVersionEqualsKibana;
var _semver = _interopRequireWildcard(require("semver"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Checks for the compatibilitiy between Elasticsearch and Kibana versions
 * 1. Major version differences will never work together.
 * 2. Older versions of ES won't work with newer versions of Kibana.
 */
function esVersionCompatibleWithKibana(esVersion, kibanaVersion) {
  const esVersionNumbers = {
    major: _semver.default.major(esVersion),
    minor: _semver.default.minor(esVersion),
    patch: _semver.default.patch(esVersion)
  };
  const kibanaVersionNumbers = {
    major: _semver.default.major(kibanaVersion),
    minor: _semver.default.minor(kibanaVersion),
    patch: _semver.default.patch(kibanaVersion)
  };

  // On 7.17: Accept the next major version of ES.
  if (esVersionNumbers.major === kibanaVersionNumbers.major + 1) {
    return true;
  }

  // Reject mismatching major version numbers.
  if (esVersionNumbers.major !== kibanaVersionNumbers.major) {
    return false;
  }

  // Reject older minor versions of ES.
  if (esVersionNumbers.minor < kibanaVersionNumbers.minor) {
    return false;
  }
  return true;
}
function esVersionEqualsKibana(nodeVersion, kibanaVersion) {
  const nodeSemVer = (0, _semver.coerce)(nodeVersion);
  const kibanaSemver = (0, _semver.coerce)(kibanaVersion);
  return nodeSemVer && kibanaSemver && nodeSemVer.version === kibanaSemver.version;
}