"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CapabilitiesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _merge_capabilities = require("./merge_capabilities");
var _resolve_capabilities = require("./resolve_capabilities");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * APIs to manage the {@link Capabilities} that will be used by the application.
 *
 * Plugins relying on capabilities to toggle some of their features should register them during the setup phase
 * using the `registerProvider` method.
 *
 * Plugins having the responsibility to restrict capabilities depending on a given context should register
 * their capabilities switcher using the `registerSwitcher` method.
 *
 * Refers to the methods documentation for complete description and examples.
 *
 * @public
 */

/**
 * Defines a set of additional options for the `resolveCapabilities` method of {@link CapabilitiesStart}.
 *
 * @public
 */

/**
 * APIs to access the application {@link Capabilities}.
 *
 * @public
 */

const defaultCapabilities = {
  navLinks: {},
  management: {},
  catalogue: {}
};

/** @internal */
class CapabilitiesService {
  constructor(core) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "capabilitiesProviders", []);
    (0, _defineProperty2.default)(this, "capabilitiesSwitchers", []);
    (0, _defineProperty2.default)(this, "resolveCapabilities", void 0);
    this.logger = core.logger.get('capabilities-service');
    this.resolveCapabilities = (0, _resolve_capabilities.getCapabilitiesResolver)(() => (0, _merge_capabilities.mergeCapabilities)(defaultCapabilities, ...this.capabilitiesProviders.map(provider => provider())), () => this.capabilitiesSwitchers);
  }
  preboot(prebootDeps) {
    this.logger.debug('Prebooting capabilities service');

    // The preboot server has no need for real capabilities.
    // Returning the un-augmented defaults is sufficient.
    prebootDeps.http.registerRoutes('', router => {
      (0, _routes.registerRoutes)(router, async () => defaultCapabilities);
    });
  }
  setup(setupDeps) {
    this.logger.debug('Setting up capabilities service');
    (0, _routes.registerRoutes)(setupDeps.http.createRouter(''), this.resolveCapabilities);
    return {
      registerProvider: provider => {
        this.capabilitiesProviders.push(provider);
      },
      registerSwitcher: switcher => {
        this.capabilitiesSwitchers.push(switcher);
      }
    };
  }
  start() {
    return {
      resolveCapabilities: (request, options) => {
        var _options$useDefaultCa;
        return this.resolveCapabilities(request, [], (_options$useDefaultCa = options === null || options === void 0 ? void 0 : options.useDefaultCapabilities) !== null && _options$useDefaultCa !== void 0 ? _options$useDefaultCa : false);
      }
    };
  }
}
exports.CapabilitiesService = CapabilitiesService;