"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstValueFrom = firstValueFrom;
exports.lastValueFrom = lastValueFrom;
var _operators = require("rxjs/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function firstValueFrom(source) {
  // we can't use SafeSubscriber the same way that RxJS 7 does, so instead we
  return source.pipe((0, _operators.first)()).toPromise();
}
function lastValueFrom(source) {
  return source.pipe((0, _operators.last)()).toPromise();
}