"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerRouteRepository = createServerRouteRepository;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createServerRouteRepository() {
  let routes = {};
  return {
    add(route) {
      routes = {
        ...routes,
        [route.endpoint]: route
      };
      return this;
    },
    merge(repository) {
      routes = {
        ...routes,
        ...Object.fromEntries(repository.getRoutes().map(route => [route.endpoint, route]))
      };
      return this;
    },
    getRoutes: () => Object.values(routes)
  };
}