"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOperator = exports.isOneOfOperator = exports.isNotOperator = exports.isNotOneOfOperator = exports.isNotInListOperator = exports.isInListOperator = exports.existsOperator = exports.doesNotExistOperator = exports.EXCEPTION_OPERATORS_SANS_LISTS = exports.EXCEPTION_OPERATORS_ONLY_LISTS = exports.EXCEPTION_OPERATORS = exports.EVENT_FILTERS_OPERATORS = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isOperator = exports.isOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOperatorLabel', {
    defaultMessage: 'is'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is'
};
const isNotOperator = exports.isNotOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOperatorLabel', {
    defaultMessage: 'is not'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is_not'
};
const isOneOfOperator = exports.isOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOneOfOperatorLabel', {
    defaultMessage: 'is one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_one_of'
};
const isNotOneOfOperator = exports.isNotOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOneOfOperatorLabel', {
    defaultMessage: 'is not one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_not_one_of'
};
const existsOperator = exports.existsOperator = {
  message: _i18n.i18n.translate('lists.exceptions.existsOperatorLabel', {
    defaultMessage: 'exists'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'exists'
};
const doesNotExistOperator = exports.doesNotExistOperator = {
  message: _i18n.i18n.translate('lists.exceptions.doesNotExistOperatorLabel', {
    defaultMessage: 'does not exist'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'does_not_exist'
};
const isInListOperator = exports.isInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isInListOperatorLabel', {
    defaultMessage: 'is in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_in_list'
};
const isNotInListOperator = exports.isNotInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotInListOperatorLabel', {
    defaultMessage: 'is not in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_not_in_list'
};
const EVENT_FILTERS_OPERATORS = exports.EVENT_FILTERS_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator];
const EXCEPTION_OPERATORS = exports.EXCEPTION_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, isInListOperator, isNotInListOperator];
const EXCEPTION_OPERATORS_SANS_LISTS = exports.EXCEPTION_OPERATORS_SANS_LISTS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator];
const EXCEPTION_OPERATORS_ONLY_LISTS = exports.EXCEPTION_OPERATORS_ONLY_LISTS = [isInListOperator, isNotInListOperator];