/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import uuid from 'uuid';
import { NonEmptyString } from '../non_empty_string';

/**
 * Types the DefaultUuid as:
 *   - If null or undefined, then a default string uuid.v4() will be
 *     created otherwise it will be checked just against an empty string
 */
export var DefaultUuid = new t.Type('DefaultUuid', t.string.is, function (input, context) {
  return input == null ? t.success(uuid.v4()) : NonEmptyString.validate(input, context);
}, t.identity);