/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { entriesMatch } from '../entry_match';
import { entriesMatchAny } from '../entry_match_any';
import { entriesExists } from '../entries_exist';
export var nestedEntryItem = t.union([entriesMatch, entriesMatchAny, entriesExists]);
export var nestedEntriesArray = t.array(nestedEntryItem);
/**
 * Types the nonEmptyNestedEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
export var nonEmptyNestedEntriesArray = new t.Type('NonEmptyNestedEntriesArray', nestedEntriesArray.is, function (input, context) {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    return nestedEntriesArray.validate(input, context);
  }
}, t.identity);