/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
export var namespaceType = t.keyof({
  agnostic: null,
  single: null
});
/**
 * Types the DefaultNamespace as:
 *   - If null or undefined, then a default string/enumeration of "single" will be used.
 */
export var DefaultNamespace = new t.Type('DefaultNamespace', namespaceType.is, function (input, context) {
  return input == null ? t.success('single') : namespaceType.validate(input, context);
}, t.identity);