"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExceptionListItemSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _default_create_comments_array = require("../../common/default_create_comments_array");
var _os_type = require("../../common/os_type");
var _description = require("../../common/description");
var _list_id = require("../../common/list_id");
var _name = require("../../common/name");
var _exception_list_item_type = require("../../common/exception_list_item_type");
var _meta = require("../../common/meta");
var _namespace_type = require("../../common/namespace_type");
var _tags = require("../../common/tags");
var _non_empty_entries_array = require("../../common/non_empty_entries_array");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createExceptionListItemSchema = exports.createExceptionListItemSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  entries: _non_empty_entries_array.nonEmptyEntriesArray,
  list_id: _list_id.list_id,
  name: _name.name,
  type: _exception_list_item_type.exceptionListItemType
})), t.exact(t.partial({
  comments: _default_create_comments_array.DefaultCreateCommentsArray,
  // defaults to empty array if not set during decode
  item_id: _securitysolutionIoTsTypes.DefaultUuid,
  // defaults to GUID (uuid v4) if not set during decode
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  namespace_type: _namespace_type.namespace_type,
  // defaults to 'single' if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags // defaults to empty array if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.