/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

import * as t from 'io-ts';
/**
 * Types the risk score as:
 *   - Natural Number (positive integer and not a float),
 *   - Between the values [0 and 100] inclusive.
 */
export var RiskScore = new t.Type('RiskScore', t.number.is, function (input, context) {
  return typeof input === 'number' && Number.isSafeInteger(input) && input >= 0 && input <= 100 ? t.success(input) : t.failure(input, context);
}, t.identity);
export var risk_score = RiskScore;
export var riskScoreOrUndefined = t.union([risk_score, t.undefined]);