"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TIMESTAMP = exports.TAGS = exports.SPACE_IDS = exports.KIBANA_NAMESPACE = exports.EVENT_KIND = exports.EVENT_ACTION = exports.ECS_VERSION = exports.CONSUMERS = exports.ALERT_WORKFLOW_USER = exports.ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_REASON = exports.ALERT_UUID = exports.ALERT_SYSTEM_STATUS = exports.ALERT_STATUS = exports.ALERT_START = exports.ALERT_SEVERITY = exports.ALERT_RULE_VERSION = exports.ALERT_RULE_UUID = exports.ALERT_RULE_UPDATED_BY = exports.ALERT_RULE_UPDATED_AT = exports.ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TYPE = exports.ALERT_RULE_TO = exports.ALERT_RULE_TAGS = exports.ALERT_RULE_SEVERITY_MAPPING = exports.ALERT_RULE_SEVERITY = exports.ALERT_RULE_RULE_NAME_OVERRIDE = exports.ALERT_RULE_RULE_ID = exports.ALERT_RULE_RISK_SCORE_MAPPING = exports.ALERT_RULE_RISK_SCORE = exports.ALERT_RULE_REFERENCES = exports.ALERT_RULE_PRODUCER = exports.ALERT_RULE_PARAMS = exports.ALERT_RULE_NOTE = exports.ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAME = exports.ALERT_RULE_LICENSE = exports.ALERT_RULE_INTERVAL = exports.ALERT_RULE_FROM = exports.ALERT_RULE_ENABLED = exports.ALERT_RULE_DESCRIPTION = exports.ALERT_RULE_CREATED_BY = exports.ALERT_RULE_CREATED_AT = exports.ALERT_RULE_CONSUMER = exports.ALERT_RULE_CATEGORY = exports.ALERT_RULE_AUTHOR = exports.ALERT_RISK_SCORE = exports.ALERT_REASON = exports.ALERT_NAMESPACE = exports.ALERT_INSTANCE_ID = exports.ALERT_EVALUATION_VALUE = exports.ALERT_EVALUATION_THRESHOLD = exports.ALERT_END = exports.ALERT_DURATION = exports.ALERT_ACTION_GROUP = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KIBANA_NAMESPACE = exports.KIBANA_NAMESPACE = 'kibana';
const ALERT_NAMESPACE = exports.ALERT_NAMESPACE = `${KIBANA_NAMESPACE}.alert`;
const ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAMESPACE = `${ALERT_NAMESPACE}.rule`;
const CONSUMERS = exports.CONSUMERS = `${KIBANA_NAMESPACE}.consumers`;
const ECS_VERSION = exports.ECS_VERSION = 'ecs.version';
const EVENT_ACTION = exports.EVENT_ACTION = 'event.action';
const EVENT_KIND = exports.EVENT_KIND = 'event.kind';
const SPACE_IDS = exports.SPACE_IDS = `${KIBANA_NAMESPACE}.space_ids`;
const TAGS = exports.TAGS = 'tags';
const TIMESTAMP = exports.TIMESTAMP = '@timestamp';
const VERSION = exports.VERSION = `${KIBANA_NAMESPACE}.version`;

// Fields pertaining to the alert
const ALERT_ACTION_GROUP = exports.ALERT_ACTION_GROUP = `${ALERT_NAMESPACE}.action_group`;
const ALERT_DURATION = exports.ALERT_DURATION = `${ALERT_NAMESPACE}.duration.us`;
const ALERT_END = exports.ALERT_END = `${ALERT_NAMESPACE}.end`;
const ALERT_EVALUATION_THRESHOLD = exports.ALERT_EVALUATION_THRESHOLD = `${ALERT_NAMESPACE}.evaluation.threshold`;
const ALERT_EVALUATION_VALUE = exports.ALERT_EVALUATION_VALUE = `${ALERT_NAMESPACE}.evaluation.value`;
const ALERT_INSTANCE_ID = exports.ALERT_INSTANCE_ID = `${ALERT_NAMESPACE}.instance.id`;
const ALERT_REASON = exports.ALERT_REASON = `${ALERT_NAMESPACE}.reason`;
const ALERT_RISK_SCORE = exports.ALERT_RISK_SCORE = `${ALERT_NAMESPACE}.risk_score`;
const ALERT_SEVERITY = exports.ALERT_SEVERITY = `${ALERT_NAMESPACE}.severity`;
const ALERT_START = exports.ALERT_START = `${ALERT_NAMESPACE}.start`;
const ALERT_STATUS = exports.ALERT_STATUS = `${ALERT_NAMESPACE}.status`;
const ALERT_SYSTEM_STATUS = exports.ALERT_SYSTEM_STATUS = `${ALERT_NAMESPACE}.system_status`;
const ALERT_UUID = exports.ALERT_UUID = `${ALERT_NAMESPACE}.uuid`;
const ALERT_WORKFLOW_REASON = exports.ALERT_WORKFLOW_REASON = `${ALERT_NAMESPACE}.workflow_reason`;
const ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_STATUS = `${ALERT_NAMESPACE}.workflow_status`;
const ALERT_WORKFLOW_USER = exports.ALERT_WORKFLOW_USER = `${ALERT_NAMESPACE}.workflow_user`;

// Fields pertaining to the rule associated with the alert
const ALERT_RULE_AUTHOR = exports.ALERT_RULE_AUTHOR = `${ALERT_RULE_NAMESPACE}.author`;
const ALERT_RULE_CREATED_AT = exports.ALERT_RULE_CREATED_AT = `${ALERT_RULE_NAMESPACE}.created_at`;
const ALERT_RULE_CREATED_BY = exports.ALERT_RULE_CREATED_BY = `${ALERT_RULE_NAMESPACE}.created_by`;
const ALERT_RULE_DESCRIPTION = exports.ALERT_RULE_DESCRIPTION = `${ALERT_RULE_NAMESPACE}.description`;
const ALERT_RULE_ENABLED = exports.ALERT_RULE_ENABLED = `${ALERT_RULE_NAMESPACE}.enabled`;
const ALERT_RULE_FROM = exports.ALERT_RULE_FROM = `${ALERT_RULE_NAMESPACE}.from`;
const ALERT_RULE_INTERVAL = exports.ALERT_RULE_INTERVAL = `${ALERT_RULE_NAMESPACE}.interval`;
const ALERT_RULE_LICENSE = exports.ALERT_RULE_LICENSE = `${ALERT_RULE_NAMESPACE}.license`;
const ALERT_RULE_CATEGORY = exports.ALERT_RULE_CATEGORY = `${ALERT_RULE_NAMESPACE}.category`;
const ALERT_RULE_NAME = exports.ALERT_RULE_NAME = `${ALERT_RULE_NAMESPACE}.name`;
const ALERT_RULE_NOTE = exports.ALERT_RULE_NOTE = `${ALERT_RULE_NAMESPACE}.note`;
const ALERT_RULE_PARAMS = exports.ALERT_RULE_PARAMS = `${ALERT_RULE_NAMESPACE}.params`;
const ALERT_RULE_REFERENCES = exports.ALERT_RULE_REFERENCES = `${ALERT_RULE_NAMESPACE}.references`;
const ALERT_RULE_RISK_SCORE = exports.ALERT_RULE_RISK_SCORE = `${ALERT_RULE_NAMESPACE}.risk_score`;
const ALERT_RULE_RISK_SCORE_MAPPING = exports.ALERT_RULE_RISK_SCORE_MAPPING = `${ALERT_RULE_NAMESPACE}.risk_score_mapping`;
const ALERT_RULE_RULE_ID = exports.ALERT_RULE_RULE_ID = `${ALERT_RULE_NAMESPACE}.rule_id`;
const ALERT_RULE_RULE_NAME_OVERRIDE = exports.ALERT_RULE_RULE_NAME_OVERRIDE = `${ALERT_RULE_NAMESPACE}.rule_name_override`;
const ALERT_RULE_SEVERITY = exports.ALERT_RULE_SEVERITY = `${ALERT_RULE_NAMESPACE}.severity`;
const ALERT_RULE_SEVERITY_MAPPING = exports.ALERT_RULE_SEVERITY_MAPPING = `${ALERT_RULE_NAMESPACE}.severity_mapping`;
const ALERT_RULE_TAGS = exports.ALERT_RULE_TAGS = `${ALERT_RULE_NAMESPACE}.tags`;
const ALERT_RULE_TO = exports.ALERT_RULE_TO = `${ALERT_RULE_NAMESPACE}.to`;
const ALERT_RULE_TYPE = exports.ALERT_RULE_TYPE = `${ALERT_RULE_NAMESPACE}.type`;
const ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TYPE_ID = `${ALERT_RULE_NAMESPACE}.rule_type_id`;
const ALERT_RULE_UPDATED_AT = exports.ALERT_RULE_UPDATED_AT = `${ALERT_RULE_NAMESPACE}.updated_at`;
const ALERT_RULE_UPDATED_BY = exports.ALERT_RULE_UPDATED_BY = `${ALERT_RULE_NAMESPACE}.updated_by`;
const ALERT_RULE_VERSION = exports.ALERT_RULE_VERSION = `${ALERT_RULE_NAMESPACE}.version`;
// the feature instantiating a rule type.
// Rule created in stack --> alerts
// Rule created in siem --> siem
const ALERT_RULE_CONSUMER = exports.ALERT_RULE_CONSUMER = `${ALERT_RULE_NAMESPACE}.consumer`;
// the plugin that registered the rule type.
// Rule type apm.error_rate --> apm
// Rule type siem.signals --> siem
const ALERT_RULE_PRODUCER = exports.ALERT_RULE_PRODUCER = `${ALERT_RULE_NAMESPACE}.producer`;
const ALERT_RULE_UUID = exports.ALERT_RULE_UUID = `${ALERT_RULE_NAMESPACE}.uuid`;
const namespaces = {
  KIBANA_NAMESPACE,
  ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE
};
const fields = {
  CONSUMERS,
  ECS_VERSION,
  EVENT_KIND,
  EVENT_ACTION,
  TAGS,
  TIMESTAMP,
  ALERT_ACTION_GROUP,
  ALERT_DURATION,
  ALERT_END,
  ALERT_EVALUATION_THRESHOLD,
  ALERT_EVALUATION_VALUE,
  ALERT_INSTANCE_ID,
  ALERT_RULE_CONSUMER,
  ALERT_RULE_PRODUCER,
  ALERT_REASON,
  ALERT_RISK_SCORE,
  ALERT_RULE_AUTHOR,
  ALERT_RULE_CREATED_AT,
  ALERT_RULE_CREATED_BY,
  ALERT_RULE_DESCRIPTION,
  ALERT_RULE_ENABLED,
  ALERT_RULE_FROM,
  ALERT_RULE_INTERVAL,
  ALERT_RULE_LICENSE,
  ALERT_RULE_NAME,
  ALERT_RULE_NOTE,
  ALERT_RULE_PARAMS,
  ALERT_RULE_REFERENCES,
  ALERT_RULE_RISK_SCORE,
  ALERT_RULE_RISK_SCORE_MAPPING,
  ALERT_RULE_RULE_ID,
  ALERT_RULE_RULE_NAME_OVERRIDE,
  ALERT_RULE_SEVERITY,
  ALERT_RULE_SEVERITY_MAPPING,
  ALERT_RULE_TAGS,
  ALERT_RULE_TO,
  ALERT_RULE_TYPE,
  ALERT_RULE_TYPE_ID,
  ALERT_RULE_UPDATED_AT,
  ALERT_RULE_UPDATED_BY,
  ALERT_RULE_VERSION,
  ALERT_START,
  ALERT_SEVERITY,
  ALERT_STATUS,
  ALERT_SYSTEM_STATUS,
  ALERT_UUID,
  ALERT_WORKFLOW_REASON,
  ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_USER,
  ALERT_RULE_UUID,
  ALERT_RULE_CATEGORY,
  SPACE_IDS,
  VERSION
};