"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnLoggerJsonFormat = void 0;
var _jsonStringifySafe = _interopRequireDefault(require("json-stringify-safe"));
var _log_format = require("./log_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-expect-error missing type def

const stripColors = function (string) {
  return string.replace(/\u001b[^m]+m/g, '');
};
class KbnLoggerJsonFormat extends _log_format.BaseLogFormat {
  format(data) {
    data.message = stripColors(data.message);
    data['@timestamp'] = this.extractAndFormatTimestamp(data);
    return (0, _jsonStringifySafe.default)(data);
  }
}
exports.KbnLoggerJsonFormat = KbnLoggerJsonFormat;