"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnionType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _errors = require("../errors");
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UnionType extends _type.Type {
  constructor(types, options) {
    const schema = _internals.internals.alternatives(types.map(type => type.getSchema())).match('any');
    super(schema, options);
  }
  handleError(type, {
    value,
    details
  }, path) {
    switch (type) {
      case 'any.required':
        return `expected at least one defined value but got [${(0, _typeDetect.default)(value)}]`;
      case 'alternatives.match':
        return new _errors.SchemaTypesError('types that failed validation:', path, details.map((detail, index) => {
          const e = detail.context.error;
          const childPathWithIndex = e.path.slice();
          childPathWithIndex.splice(path.length, 0, index.toString());
          return e instanceof _errors.SchemaTypesError ? new _errors.SchemaTypesError(e.message, childPathWithIndex, e.errors) : new _errors.SchemaTypeError(e.message, childPathWithIndex);
        }));
    }
  }
}
exports.UnionType = UnionType;