"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportStorageManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ReportStorageManager {
  constructor(storageKey, storage) {
    (0, _defineProperty2.default)(this, "storageKey", void 0);
    (0, _defineProperty2.default)(this, "storage", void 0);
    this.storageKey = storageKey;
    this.storage = storage;
  }
  get() {
    if (!this.storage) return;
    return this.storage.get(this.storageKey);
  }
  store(report) {
    if (!this.storage) return;
    this.storage.set(this.storageKey, report);
  }
}
exports.ReportStorageManager = ReportStorageManager;