"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileLayer = exports.EMSFormatType = void 0;
var _url = _interopRequireDefault(require("url"));
var _ems_service = require("./ems_service");
var topojson = _interopRequireWildcard(require("topojson-client"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let EMSFormatType = exports.EMSFormatType = /*#__PURE__*/function (EMSFormatType) {
  EMSFormatType["geojson"] = "geojson";
  EMSFormatType["topojson"] = "topojson";
  return EMSFormatType;
}({});
class FileLayer extends _ems_service.AbstractEmsService {
  constructor(config, emsClient, proxyPath) {
    super(config, emsClient, proxyPath);
    _defineProperty(this, "_config", void 0);
    this._config = config;
  }
  async getGeoJson() {
    const cachedGeoJson = this._emsClient.getCachedGeoJson(this.getId());
    if (cachedGeoJson) {
      return cachedGeoJson;
    }
    const format = this.getDefaultFormatType();
    const fetchUrl = this.getDefaultFormatUrl();
    let geojson;
    const fetchedJson = await this._emsClient.getManifest(fetchUrl);
    if (fetchedJson) {
      if (format === 'geojson') {
        geojson = fetchedJson;
      } else if (format === 'topojson') {
        const meta = this.getDefaultFormatMeta();
        const featureCollectionPath = meta?.feature_collection_path ?? 'data';
        // @ts-expect-error see https://github.com/DefinitelyTyped/DefinitelyTyped/pull/52156
        geojson = topojson.feature(fetchedJson, featureCollectionPath);
      } else {
        return;
      }
      this._emsClient.cacheGeoJson(this.getId(), geojson);
      return geojson;
    }
    return;
  }
  getFields() {
    return this._config.fields;
  }
  getFieldsInLanguage() {
    return this.getFields().map(field => {
      return {
        type: field.type,
        name: field.id,
        description: this._emsClient.getValueInLanguage(field.label)
      };
    });
  }
  getDisplayName() {
    const layerName = this._emsClient.getValueInLanguage(this._config.layer_name);
    return layerName ? layerName : '';
  }
  getId() {
    return this._config.layer_id;
  }
  hasId(id) {
    const matchesLegacyId = this._config.legacy_ids.indexOf(id) >= 0;
    return this._config.layer_id === id || matchesLegacyId;
  }
  getEMSHotLink() {
    const landingPageString = this._emsClient.getLandingPageUrl();
    const urlObject = _url.default.parse(landingPageString, true);
    urlObject.hash = `file/${this.getId()}`;
    urlObject.query = {
      ...urlObject.query,
      locale: this._emsClient.getLocale()
    };
    return _url.default.format(urlObject);
  }
  getDefaultFormatType() {
    const format = this._getDefaultFormat();
    return format.type;
  }
  getFormatOfType(type) {
    const format = this._getFormatOfType(type);
    return format.type;
  }
  getDefaultFormatMeta() {
    const format = this._getDefaultFormat();
    return this._getFormatMeta(format);
  }
  getFormatOfTypeMeta(type) {
    const format = this._getFormatOfType(type);
    return this._getFormatMeta(format);
  }
  getDefaultFormatUrl() {
    const format = this._getDefaultFormat();
    return this._getFormatUrl(format);
  }
  getFormatOfTypeUrl(type) {
    const format = this._getFormatOfType(type);
    return this._getFormatUrl(format);
  }
  getCreatedAt() {
    return this._config.created_at;
  }
  getApiUrl() {
    return this._emsClient.getFileApiUrl();
  }
  _getFormatUrl(format) {
    const url = this._proxyPath + this._getAbsoluteUrl(format.url);
    return this._emsClient.extendUrlWithParams(url);
  }
  _getFormatMeta(format) {
    if ('meta' in format) {
      return format.meta;
    } else {
      return;
    }
  }
  _getDefaultFormat() {
    const defaultFormat = this._config.formats.find(format => {
      return format.legacy_default;
    });
    if (defaultFormat) {
      return defaultFormat;
    }
    return this._config.formats[0];
  }
  _getFormatOfType(type) {
    const requestedFormat = this._config.formats.find(format => {
      return format.type === type;
    });
    return requestedFormat || this._getDefaultFormat();
  }
}
exports.FileLayer = FileLayer;