"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGridHeightParamsSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var legend_1 = require("../../../../utils/legend");
var get_heatmap_config_1 = require("./get_heatmap_config");
var get_heatmap_table_1 = require("./get_heatmap_table");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.getGridHeightParamsSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_legend_size_1.getLegendSizeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    getParentDimension,
    get_heatmap_config_1.getHeatmapConfigSelector,
    get_heatmap_table_1.getHeatmapTableSelector,
], function (legendSize, _a, _b, _c, _d) {
    var showLegend = _a.showLegend;
    var containerHeight = _b.height;
    var _e = _c.xAxisLabel, padding = _e.padding, visible = _e.visible, fontSize = _e.fontSize, grid = _c.grid, maxLegendHeight = _c.maxLegendHeight;
    var yValues = _d.yValues;
    var xAxisHeight = visible ? fontSize : 0;
    var totalVerticalPadding = padding * 2;
    var legendHeight = 0;
    if (showLegend && (0, legend_1.isHorizontalLegend)(legendSize.position)) {
        legendHeight = maxLegendHeight !== null && maxLegendHeight !== void 0 ? maxLegendHeight : legendSize.height;
    }
    var verticalRemainingSpace = containerHeight - xAxisHeight - totalVerticalPadding - legendHeight;
    var gridCellHeight = getGridCellHeight(yValues, grid, verticalRemainingSpace);
    var height = gridCellHeight * yValues.length;
    var pageSize = gridCellHeight > 0 && height > containerHeight
        ? Math.floor(verticalRemainingSpace / gridCellHeight)
        : yValues.length;
    return {
        height: height,
        gridCellHeight: gridCellHeight,
        pageSize: pageSize,
    };
});
function getGridCellHeight(yValues, grid, height) {
    if (yValues.length === 0) {
        return height;
    }
    var stretchedHeight = height / yValues.length;
    if (stretchedHeight < grid.cellHeight.min) {
        return grid.cellHeight.min;
    }
    if (grid.cellHeight.max !== 'fill' && stretchedHeight > grid.cellHeight.max) {
        return grid.cellHeight.max;
    }
    return stretchedHeight;
}
//# sourceMappingURL=get_grid_full_height.js.map