// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteQUICInitialRuleFrontendAcceptedCode is the HTTP code returned for type DeleteQUICInitialRuleFrontendAccepted
const DeleteQUICInitialRuleFrontendAcceptedCode int = 202

/*
DeleteQUICInitialRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteQuicInitialRuleFrontendAccepted
*/
type DeleteQUICInitialRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteQUICInitialRuleFrontendAccepted creates DeleteQUICInitialRuleFrontendAccepted with default headers values
func NewDeleteQUICInitialRuleFrontendAccepted() *DeleteQUICInitialRuleFrontendAccepted {

	return &DeleteQUICInitialRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Quic initial rule frontend accepted response
func (o *DeleteQUICInitialRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteQUICInitialRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Quic initial rule frontend accepted response
func (o *DeleteQUICInitialRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteQUICInitialRuleFrontendNoContentCode is the HTTP code returned for type DeleteQUICInitialRuleFrontendNoContent
const DeleteQUICInitialRuleFrontendNoContentCode int = 204

/*
DeleteQUICInitialRuleFrontendNoContent QUIC Initial Rule deleted

swagger:response deleteQuicInitialRuleFrontendNoContent
*/
type DeleteQUICInitialRuleFrontendNoContent struct {
}

// NewDeleteQUICInitialRuleFrontendNoContent creates DeleteQUICInitialRuleFrontendNoContent with default headers values
func NewDeleteQUICInitialRuleFrontendNoContent() *DeleteQUICInitialRuleFrontendNoContent {

	return &DeleteQUICInitialRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteQUICInitialRuleFrontendNotFoundCode is the HTTP code returned for type DeleteQUICInitialRuleFrontendNotFound
const DeleteQUICInitialRuleFrontendNotFoundCode int = 404

/*
DeleteQUICInitialRuleFrontendNotFound The specified resource was not found

swagger:response deleteQuicInitialRuleFrontendNotFound
*/
type DeleteQUICInitialRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteQUICInitialRuleFrontendNotFound creates DeleteQUICInitialRuleFrontendNotFound with default headers values
func NewDeleteQUICInitialRuleFrontendNotFound() *DeleteQUICInitialRuleFrontendNotFound {

	return &DeleteQUICInitialRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Quic initial rule frontend not found response
func (o *DeleteQUICInitialRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteQUICInitialRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Quic initial rule frontend not found response
func (o *DeleteQUICInitialRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Quic initial rule frontend not found response
func (o *DeleteQUICInitialRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteQUICInitialRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Quic initial rule frontend not found response
func (o *DeleteQUICInitialRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteQUICInitialRuleFrontendDefault General Error

swagger:response deleteQuicInitialRuleFrontendDefault
*/
type DeleteQUICInitialRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteQUICInitialRuleFrontendDefault creates DeleteQUICInitialRuleFrontendDefault with default headers values
func NewDeleteQUICInitialRuleFrontendDefault(code int) *DeleteQUICInitialRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteQUICInitialRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) WithStatusCode(code int) *DeleteQUICInitialRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteQUICInitialRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteQUICInitialRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete QUIC initial rule frontend default response
func (o *DeleteQUICInitialRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
