/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.TestResultModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.tasks.testing.TestResult;

public class TestResult
extends TestResultModel
implements Comparable<TestResult> {
    private final long duration;
    private final ClassTestResults classResults;
    private final List<SerializableFailure> failures = new ArrayList<SerializableFailure>();
    private final String name;
    private final String displayName;
    private boolean ignored;

    public TestResult(String name, long duration, ClassTestResults classResults) {
        this(name, name, duration, classResults);
    }

    public TestResult(String name, String displayName, long duration, ClassTestResults classResults) {
        this.name = name;
        this.duration = duration;
        this.displayName = displayName;
        this.classResults = classResults;
    }

    public Object getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getTitle() {
        return "Test " + this.name;
    }

    @Override
    public TestResult.ResultType getResultType() {
        if (this.ignored) {
            return TestResult.ResultType.SKIPPED;
        }
        return this.failures.isEmpty() ? TestResult.ResultType.SUCCESS : TestResult.ResultType.FAILURE;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return this.ignored ? "-" : super.getFormattedDuration();
    }

    public ClassTestResults getClassResults() {
        return this.classResults;
    }

    public List<SerializableFailure> getFailures() {
        return this.failures;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void addFailure(SerializableFailure failure) {
        this.classResults.failed(this);
        this.failures.add(failure);
    }

    public void markIgnored(@Nullable SerializableFailure assumptionFailure) {
        this.classResults.ignored(this);
        this.ignored = true;
        if (assumptionFailure != null) {
            this.failures.add(assumptionFailure);
        }
    }

    @Override
    public int compareTo(TestResult testResult) {
        int diff = this.classResults.getName().compareTo(testResult.classResults.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.name.compareTo(testResult.name);
        if (diff != 0) {
            return diff;
        }
        Integer thisIdentity = System.identityHashCode(this);
        int otherIdentity = System.identityHashCode(testResult);
        return thisIdentity.compareTo(otherIdentity);
    }
}

