#!/bin/sh

# Copyright 2023-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

set -e
set -u
trap "exit 128" INT

admin="$(realpath "$(dirname "${0}")")"
source="$(realpath "${admin}/../")"

export DOTNET_CLI_TELEMETRY_OPTOUT="1"
export DOTNET_NOLOGO="1"
export DOTNET_SKIP_FIRST_TIME_EXPERIENCE="1"

export POWERSHELL_TELEMETRY_OPTOUT="1"
export POWERSHELL_UPDATECHECK="0"

export MSBUILDDISABLENODEREUSE="1"
export MSBUILDTERMINALLOGGER="off"

export ContinuousIntegrationBuild="true"
export RollForward="Major"
export UseSharedCompilation="false"

export PATH="${PATH}:${HOME}/.dotnet/tools"

cd "${source}"
exec dotnet "${@}"
