/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;

public abstract class LogicalExpression
extends Expression {
    protected Expression lhs;
    protected Expression rhs;

    LogicalExpression(Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        TypedValue[] lhstv = this.lhs.getTypedValues(sessionFactory, persistentClass);
        TypedValue[] rhstv = this.rhs.getTypedValues(sessionFactory, persistentClass);
        TypedValue[] result = new TypedValue[lhstv.length + rhstv.length];
        System.arraycopy(lhstv, 0, result, 0, lhstv.length);
        System.arraycopy(rhstv, 0, result, lhstv.length, rhstv.length);
        return result;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return '(' + this.lhs.toSqlString(sessionFactory, persistentClass, alias) + ' ' + this.getOp() + ' ' + this.rhs.toSqlString(sessionFactory, persistentClass, alias) + ')';
    }

    abstract String getOp();

    public String toString() {
        return this.lhs.toString() + ' ' + this.getOp() + ' ' + this.rhs.toString();
    }
}

