/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PathsUtils {
    private static final String REGEXP_CHARS = "*+?[]$^.{}|()";
    private static final char ESCAPE_CHARACTER = "\\".charAt(0);

    public static String reformatRegexp(String sourceString, String destString, Pattern regexPattern) {
        String target = destString;
        Matcher matcher = regexPattern.matcher(sourceString.replace("\\", "/"));
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String currentGroup = matcher.group(i);
                if (currentGroup == null) continue;
                target = target.replace("{" + i + "}", currentGroup);
            }
        }
        return target;
    }

    public static String substringBeforeFirstRegex(String baseDir) {
        char nextChar;
        if (StringUtils.isEmpty(baseDir)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int length = baseDir.length();
        for (int i = 0; i < length && !StringUtils.contains(REGEXP_CHARS, nextChar = baseDir.charAt(i)); ++i) {
            if (nextChar == ESCAPE_CHARACTER) {
                if (baseDir.length() < i + 2) {
                    throw new IllegalStateException("Base directory: " + baseDir + " ends with an escape character.");
                }
                result.append(baseDir.charAt(i + 1));
                ++i;
                continue;
            }
            result.append(baseDir.charAt(i));
        }
        return result.toString();
    }

    public static String escapeRegexChars(String pattern) {
        if (StringUtils.isEmpty(pattern)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            String nextChar = pattern.substring(i, i + 1);
            if (StringUtils.contains(REGEXP_CHARS, nextChar)) {
                result.append(ESCAPE_CHARACTER).append(nextChar);
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public static String pathToRegExp(String path) {
        String wildcard = ".*";
        StringBuilder sb = new StringBuilder(path.length());
        int length = path.length();
        int is = length;
        block5: for (int i = 0; i < is; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(wildcard);
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                case '$': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append("\\");
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String newPath = sb.toString();
        if (newPath.endsWith("/")) {
            newPath = newPath + wildcard;
        }
        return "^" + newPath + "$";
    }

    public static Map<String, String> replaceFilesName(String targetPath, String srcPath) {
        String targetDirPath = StringUtils.substringBeforeLast(targetPath, "/");
        String targetFileName = StringUtils.substringAfterLast(targetPath, "/");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("targetPath", targetDirPath);
        result.put("srcPath", srcPath.contains("/") ? StringUtils.substringBeforeLast(srcPath, "/") + "/" + targetFileName : targetFileName);
        return result;
    }

    public static String removeUnescapedChar(String stringToRemoveFrom, Character characterToRemove) {
        String separator = String.valueOf(characterToRemove);
        if (REGEXP_CHARS.contains(separator)) {
            separator = "\\" + characterToRemove;
        }
        String[] strings = stringToRemoveFrom.split(separator);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            if (string.endsWith("\\")) {
                stringBuilder.append(string).append(characterToRemove);
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String escapeSpecialChars(String str) {
        String specialChars = "\\*+?[]$^.{}|()";
        for (char c : specialChars.toCharArray()) {
            str = str.replace(String.valueOf(c), "\\" + c);
        }
        return str;
    }
}

