/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ButtonUtil {
    public static final int NO_PADDING = 0;
    public static final int LEFT_PADDING = 1;
    public static final int RIGHT_PADDING = 2;
    public static final int CENTER_PADDING = 3;
    public static final String CLIENT_PROPERTY_EQUALIZE = "buttonEqualize";
    private static final Dimension BUTTONS_HORIZONTAL_GAP = new Dimension(GUIHelper.isWindowsLaF() ? 5 : 0, 0);
    private static final Dimension BUTTONS_VERTICAL_GAP = new Dimension(0, 0);

    private ButtonUtil() {
    }

    public static Box createHorizontalButtonBox(Component[] componentArray, int n) {
        Box box = Box.createHorizontalBox();
        ButtonUtil.fillButtonBox(box, ButtonUtil.equalizeButtonsForHorizontalBox(componentArray), Box.createHorizontalGlue(), n);
        return box;
    }

    public static Box createVerticalButtonBox(Component[] componentArray, int n) {
        Box box = Box.createVerticalBox();
        ButtonUtil.fillButtonBox(box, ButtonUtil.equalizeButtonsForVerticalBox(componentArray), Box.createVerticalGlue(), n);
        return box;
    }

    private static void fillButtonBox(Box box, Component[] componentArray, Component component, int n) {
        if ((n & 1) != 0) {
            box.add(component);
        }
        for (int i = 0; i < componentArray.length; ++i) {
            box.add(componentArray[i]);
        }
        if ((n & 2) != 0) {
            box.add(component);
        }
    }

    public static Component[] equalizeButtonsForVerticalBox(Component[] componentArray) {
        return ButtonUtil.equalizeButtonsForBox(componentArray, BUTTONS_VERTICAL_GAP);
    }

    public static Component[] equalizeButtonsForHorizontalBox(Component[] componentArray) {
        return ButtonUtil.equalizeButtonsForBox(componentArray, BUTTONS_HORIZONTAL_GAP);
    }

    private static Component[] equalizeButtonsForBox(Component[] componentArray, Dimension dimension) {
        Serializable serializable;
        Component component;
        LinkedList<Component> linkedList = new LinkedList<Component>();
        LinkedList<Serializable> linkedList2 = new LinkedList<Serializable>();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            if (component instanceof JButton) {
                Boolean bl;
                serializable = (JButton)component;
                if (((AbstractButton)serializable).getText() != null && ((AbstractButton)serializable).getText().length() != 0) {
                    ((JComponent)serializable).setPreferredSize(null);
                }
                if ((bl = (Boolean)((JComponent)serializable).getClientProperty(CLIENT_PROPERTY_EQUALIZE)) == null || bl.booleanValue()) {
                    n = Math.max(n, ((JComponent)serializable).getPreferredSize().width);
                    linkedList2.add(serializable);
                }
                if (i > 0) {
                    linkedList.add(Box.createRigidArea(dimension));
                }
            }
            linkedList.add(component);
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            component = (JButton)iterator.next();
            serializable = ((JComponent)component).getPreferredSize();
            ((Dimension)serializable).width = n;
            ((JComponent)component).setPreferredSize((Dimension)serializable);
            ((JComponent)component).setMinimumSize((Dimension)serializable);
            ((JComponent)component).setMaximumSize((Dimension)serializable);
        }
        return linkedList.toArray(componentArray);
    }
}

