/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.install4j.api.Util;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.update.DownloadAction;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.Md5Checker;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class DownloadFileAction
extends DownloadAction {
    private String url;
    private String targetFile;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean deleteOnExit = false;
    private boolean checkForMd5Sums = false;
    private String md5Url = "";
    private boolean dontAskForRetry = false;
    private boolean retryIfInterrupted = true;
    static /* synthetic */ Class class$com$install4j$runtime$beans$actions$update$DownloadFileAction;

    public String getUrl() {
        return DownloadFileAction.replaceVariables(this.url);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public boolean isCheckForMd5Sums() {
        return this.checkForMd5Sums;
    }

    public void setCheckForMd5Sums(boolean bl) {
        this.checkForMd5Sums = bl;
    }

    public String getMd5Url() {
        return this.md5Url;
    }

    public void setMd5Url(String string) {
        this.md5Url = string;
    }

    public boolean isDontAskForRetry() {
        return this.dontAskForRetry;
    }

    public void setDontAskForRetry(boolean bl) {
        this.dontAskForRetry = bl;
    }

    public boolean isRetryIfInterrupted() {
        return this.retryIfInterrupted;
    }

    public void setRetryIfInterrupted(boolean bl) {
        this.retryIfInterrupted = bl;
    }

    public String getTargetFile() {
        return DownloadFileAction.replaceVariables(this.targetFile);
    }

    public void setTargetFile(String string) {
        this.targetFile = string;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public void setShowFileName(boolean bl) {
        this.showFileName = bl;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws UserCanceledException {
        Object object;
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        File file = context.getDestinationFile(this.getTargetFile());
        ProgressInterface progressInterface = context.getProgressInterface();
        if (this.showProgress) {
            if (this.showFileName) {
                object = file.getName();
                progressInterface.setStatusMessage("<html><nobr>" + MessageFormat.format(variableResourceBundleWrapper.getString("DownloadingWithFileName"), "<b>" + (String)object + "</b>") + "</nobr>");
            } else {
                progressInterface.setStatusMessage(variableResourceBundleWrapper.getString("Downloading"));
            }
        } else {
            progressInterface = new NoPercentageProgressDelegate(progressInterface);
        }
        object = null;
        if (context instanceof InstallerContext && file.exists()) {
            object = new BackupFileForRollbackAction(file, true);
            ((BackupFileForRollbackAction)object).install((InstallerContext)context);
            this.addRollbackAction((InstallAction)object);
        }
        try {
            boolean bl = DownloadFileAction.doDownload(context, file, this.showProgress ? progressInterface : null, this.getUrl(), this.isAskForProxy(), this.isDeleteOnExit(), this.isRetryIfInterrupted(), this.isCheckForMd5Sums(), this.getMd5Url(), this.isDontAskForRetry());
            return bl;
        }
        catch (IOException iOException) {
            if (this.isShowError()) {
                Util.showErrorMessage(MessageFormat.format(variableResourceBundleWrapper.getString("updater.DownloadError"), this.getUrl()));
            }
            Logger.getInstance().error(this, "could not download file");
            Logger.getInstance().log(iOException);
            if (object != null) {
                ((BackupFileForRollbackAction)object).rollback((InstallerContext)context);
                object = null;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (object != null) {
                this.addRollbackAction((InstallAction)object);
            }
        }
    }

    private static boolean doDownload(Context context, File file, ProgressInterface progressInterface, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, boolean bl5) throws UserCanceledException, IOException {
        Downloader downloader = new Downloader(context, progressInterface, bl);
        boolean bl6 = true;
        String string3 = null;
        String string4 = null;
        while (true) {
            boolean bl7 = false;
            try {
                downloader.connect(string);
            }
            catch (UserCanceledException userCanceledException) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                bl6 = false;
            }
            if (bl6) {
                try {
                    downloader.download(file, -1L, bl2);
                    string4 = Md5Checker.getHexStringFromBytes(downloader.digest());
                }
                catch (IOException iOException) {
                    if (bl3) {
                        Logger.getInstance().error(class$com$install4j$runtime$beans$actions$update$DownloadFileAction == null ? DownloadFileAction.class$("com.install4j.runtime.beans.actions.update.DownloadFileAction") : class$com$install4j$runtime$beans$actions$update$DownloadFileAction, "could not download file");
                        Logger.getInstance().log(iOException);
                        bl7 = bl6 = DownloadFileAction.askRetry("DownloadInterrupted");
                    }
                    throw iOException;
                }
            }
            if (bl7) continue;
            if (bl6) {
                if (string3 == null) {
                    if (bl4) {
                        String string5 = string2;
                        if (string5 == null || string5.trim().length() == 0) {
                            string5 = Md5Checker.createMd5Url(string);
                        }
                        string3 = Md5Checker.getExpectedMd5(context, bl, string5, file.getName());
                    } else {
                        string3 = "";
                    }
                }
                if (!"".equals(string3)) {
                    Logger.getInstance().info(class$com$install4j$runtime$beans$actions$update$DownloadFileAction == null ? DownloadFileAction.class$("com.install4j.runtime.beans.actions.update.DownloadFileAction") : class$com$install4j$runtime$beans$actions$update$DownloadFileAction, "expected md5 " + string3 + ", real md5 " + string4);
                    if (!string3.equals(string4)) {
                        downloader.resetLastDownload();
                        bl6 = bl5 ? false : DownloadFileAction.askRetry("DownloadFileCorrupt");
                    }
                }
            }
            if (!bl6 || "".equals(string3) || string4.equals(string3)) break;
        }
        return bl6;
    }

    private static boolean askRetry(String string) throws UserCanceledException {
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        switch (Util.showOptionDialog(variableResourceBundleWrapper.getString(string), new String[]{variableResourceBundleWrapper.getString("ButtonYes"), variableResourceBundleWrapper.getString("ButtonNo"), variableResourceBundleWrapper.getString("ButtonCancel")}, 2)) {
            case 2: {
                throw new UserCanceledException();
            }
            case -1: 
            case 1: {
                return false;
            }
        }
        return true;
    }
}

