/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinAssociations;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.desktop.MacAssociationRole;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public class CreateFileAssociationAction
extends SystemAutoUninstallInstallAction {
    private String extension = "";
    private String description = "";
    private String launcherId = "";
    private boolean selected = true;
    private boolean windows = true;
    private ExternalFile windowsIconFile = null;
    private String winAdditionalParameters = null;
    private boolean mac = true;
    private ExternalFile macIconFile = null;
    private boolean restartFinder = false;
    private MacAssociationRole macAssociationRole = MacAssociationRole.VIEWER;
    private static final String PROP_EXTENSION = "extension";
    private static final String PROP_EXECUTABLE = "executable";
    private static boolean finderRestarted = false;

    public boolean isRestartFinder() {
        return this.restartFinder;
    }

    public void setRestartFinder(boolean bl) {
        this.restartFinder = bl;
    }

    public String getExtension() {
        return CreateFileAssociationAction.replaceVariables(this.extension);
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getDescription() {
        return CreateFileAssociationAction.replaceVariables(this.description, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public void setWindows(boolean bl) {
        this.windows = bl;
    }

    public ExternalFile getWindowsIconFile() {
        return this.windowsIconFile;
    }

    public void setWindowsIconFile(ExternalFile externalFile) {
        this.windowsIconFile = externalFile;
    }

    public String getWinAdditionalParameters() {
        return CreateFileAssociationAction.replaceVariables(this.winAdditionalParameters);
    }

    public void setWinAdditionalParameters(String string) {
        this.winAdditionalParameters = string;
    }

    public boolean isMac() {
        return this.mac;
    }

    public void setMac(boolean bl) {
        this.mac = bl;
    }

    public ExternalFile getMacIconFile() {
        return this.macIconFile;
    }

    public void setMacIconFile(ExternalFile externalFile) {
        this.macIconFile = externalFile;
    }

    public MacAssociationRole getMacRole() {
        return this.macAssociationRole;
    }

    public void setMacRole(MacAssociationRole macAssociationRole) {
        this.macAssociationRole = macAssociationRole;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (!this.isSelected()) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows() && this.isWindows()) {
                return this.installWindows(installerContext);
            }
            if (InstallerUtil.isMacOS() && this.isMac()) {
                return this.installMac(installerContext);
            }
        }
        catch (IOException iOException) {
            Util.log(iOException);
            return false;
        }
        return true;
    }

    public boolean uninstall(UninstallerContext uninstallerContext) {
        try {
            if (InstallerUtil.isWindows()) {
                this.uninstallWindows();
            }
        }
        catch (Throwable throwable) {
            Util.log(throwable);
        }
        return true;
    }

    private void uninstallWindows() throws IOException {
        Properties properties = this.getPersistentProperties();
        String string = properties.getProperty(PROP_EXTENSION);
        String string2 = properties.getProperty(PROP_EXECUTABLE);
        if (string2 == null || string == null) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        File file = new File(string2).getCanonicalFile();
        String string3 = WinAssociations.getExecutable(string);
        if (string3 != null && new File(string3).getCanonicalFile().equals(file)) {
            WinAssociations.remove(string);
        }
    }

    private boolean installWindows(InstallerContext installerContext) throws UserCanceledException {
        File file = this.getExecutableFile(installerContext);
        if (file == null || !file.exists()) {
            Util.logError(this, "executable does not exist: " + file);
            return false;
        }
        File file2 = installerContext.getExternalFile(this.getWindowsIconFile(), true);
        String string = this.getExtension();
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        this.addRollbackActions(FileAssociations.create(string, this.getDescription(), file2, file, this.getWinAdditionalParameters()));
        Properties properties = this.getPersistentProperties();
        properties.setProperty(PROP_EXTENSION, string);
        properties.setProperty(PROP_EXECUTABLE, file.getAbsolutePath());
        return true;
    }

    private boolean installMac(InstallerContext installerContext) throws IOException {
        File file = this.getBundleDir(installerContext);
        if (file != null && file.exists()) {
            File file2 = new File(file, "Contents/Info.plist");
            if (file2.exists()) {
                CreateFileAssociationAction.addAssociation(file2, this.getExtension(), this.getDescription(), installerContext.getExternalFile(this.getMacIconFile(), true), this.getMacRole().toString());
                this.refresh(file);
                return true;
            }
            Util.logError(this, "infoPlistFile not found: " + file2);
        } else {
            Util.logError(this, "bundleDir not found: " + file);
        }
        return false;
    }

    private File getBundleDir(Context context) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file = null;
        if (installerConfig.getMacSpecificConfig().isSingleBundle()) {
            file = context.getDestinationFile(installerConfig.getMacSpecificConfig().getSingleBundleName());
        } else {
            LauncherConfig launcherConfig = installerConfig.getLauncherConfigById(this.getLauncherId());
            if (launcherConfig != null) {
                file = context.getDestinationFile(launcherConfig.getFile());
            }
        }
        return file;
    }

    private File getExecutableFile(Context context) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        LauncherConfig launcherConfig = installerConfig.getLauncherConfigById(this.getLauncherId());
        if (launcherConfig == null) {
            return null;
        }
        return context.getDestinationFile(launcherConfig.getFile());
    }

    private void refresh(File file) {
        try {
            String[] stringArray = new String[]{"/System/Library/Frameworks/ApplicationServices.framework/Frameworks/LaunchServices.framework/Support/lsregister", "-R", "-f", file.getAbsolutePath()};
            if (!new File(stringArray[0]).exists()) {
                stringArray[0] = "/System/Library/Frameworks/CoreServices.framework/Frameworks/LaunchServices.framework/Support/lsregister";
            }
            if (!Execution.executeAndWait(stringArray, null)) {
                Util.logError(this, "refresh db not successful");
            }
        }
        catch (IOException iOException) {
            Util.logError(this, "could not refresh db: " + iOException.getMessage());
        }
        if (this.restartFinder && !finderRestarted) {
            finderRestarted = true;
            Runtime.getRuntime().addShutdownHook(new Thread("finder restart"){

                public void run() {
                    try {
                        Runtime.getRuntime().exec("killall -SIGHUP Finder");
                    }
                    catch (IOException iOException) {
                        System.err.println("could not restart finder: " + iOException.getMessage());
                    }
                }
            });
        }
    }

    private static void addAssociation(File file, String string, String string2, File file2, String string3) throws IOException {
        File file3;
        if (file2 != null) {
            file3 = new File(new File(file.getParentFile(), "Resources"), file2.getName());
            FileUtil.copyFile(file2, file3);
            FileInstaller.getInstance().registerUninstallFile(file3);
        }
        file3 = new File(file.getAbsolutePath() + ".temp");
        file3.delete();
        file.renameTo(file3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8"));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        String string4 = bufferedReader.readLine();
        boolean bl = false;
        boolean bl2 = false;
        while (string4 != null) {
            printWriter.println(string4);
            String string5 = bufferedReader.readLine();
            if (!bl2) {
                if (string4.indexOf("CFBundleDocumentTypes") > -1) {
                    bl = true;
                } else if (bl && string4.indexOf("<array>") > -1) {
                    CreateFileAssociationAction.insertAssociation(printWriter, string, string2, file2, string3);
                    bl2 = true;
                } else if (string4.indexOf("<!-- I4J_INSERT_DOCTYPE -->") > -1 && (string5 == null || string5.indexOf("CFBundleDocumentTypes") == -1)) {
                    printWriter.println("<key>CFBundleDocumentTypes</key>");
                    printWriter.println("<array>");
                    CreateFileAssociationAction.insertAssociation(printWriter, string, string2, file2, string3);
                    printWriter.println("</array>");
                    bl2 = true;
                }
            }
            string4 = string5;
        }
        printWriter.close();
        bufferedReader.close();
        file3.delete();
    }

    private static void insertAssociation(PrintWriter printWriter, String string, String string2, File file, String string3) {
        printWriter.println("<dict>");
        printWriter.println("<key>CFBundleTypeExtensions</key>");
        printWriter.println("<array>");
        printWriter.println("<string>" + string + "</string>");
        printWriter.println("</array>");
        printWriter.println("<key>CFBundleTypeName</key>");
        printWriter.println("<string>" + string2 + "</string>");
        if (file != null) {
            printWriter.println("<key>CFBundleTypeIconFile</key>");
            printWriter.println("<string>" + file.getName() + "</string>");
        }
        printWriter.println("<key>CFBundleTypeRole</key>");
        printWriter.println("<string>" + string3 + "</string>");
        printWriter.println("</dict>");
    }

    public void rollback(InstallerContext installerContext) {
        super.rollback(installerContext);
        if (InstallerUtil.isWindows()) {
            Registry.changeNotifyAssociations();
        }
    }

    public boolean fileExists(Context context) {
        File file = null;
        if (Util.isWindowsInstaller()) {
            file = this.getExecutableFile(context);
        } else if (Util.isMacosInstaller()) {
            file = this.getBundleDir(context);
        }
        return file != null && file.exists();
    }
}

