/*
 * Decompiled with CFR 0.152.
 */
package jflex.option;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import jflex.l10n.ErrorMessages;

public class Options {
    private static final Set<ErrorMessages> suppressedWarnings = new HashSet<ErrorMessages>();
    public static File directory;
    private static File rootDirectory;
    public static boolean jlex;
    public static boolean no_minimize;
    public static boolean no_backup;
    public static boolean verbose;
    public static boolean progress;
    public static boolean time;
    public static boolean dot;
    public static boolean dump;
    public static boolean legacy_dot;
    public static Charset encoding;

    private Options() {
    }

    public static File getDir() {
        return directory;
    }

    public static File getRootDirectory() {
        return rootDirectory;
    }

    public static void setRootDirectory(File rootDir) {
        rootDirectory = rootDir;
    }

    public static void resetRootDirectory() {
        rootDirectory = new File("");
    }

    public static boolean isSuppressed(ErrorMessages msg) {
        return suppressedWarnings.contains((Object)msg);
    }

    public static void suppress(ErrorMessages msg) {
        if (!ErrorMessages.isConfigurableWarning(msg)) {
            throw new IllegalArgumentException("Cannot suppress non-configurable warning: " + (Object)((Object)msg));
        }
        suppressedWarnings.add(msg);
    }

    public static void enable(ErrorMessages msg) {
        if (!ErrorMessages.isConfigurableWarning(msg)) {
            throw new IllegalArgumentException("Cannot enable non-configurable warning: " + (Object)((Object)msg));
        }
        suppressedWarnings.remove((Object)msg);
    }

    static {
        verbose = true;
    }
}

