/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.nio.charset.Charset;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.skeleton.Skeleton;

public class OptionUtils {
    private OptionUtils() {
    }

    public static void setEncoding(String encodingName) {
        if (!Charset.isSupported(encodingName)) {
            Out.error(ErrorMessages.CHARSET_NOT_SUPPORTED, encodingName);
            throw new GeneratorException();
        }
        Options.encoding = Charset.forName(encodingName);
    }

    public static void setDefaultOptions() {
        Options.directory = null;
        Options.resetRootDirectory();
        Options.jlex = false;
        Options.no_minimize = false;
        Options.no_backup = false;
        Options.verbose = true;
        Options.progress = true;
        Options.time = false;
        Options.dot = false;
        Options.dump = false;
        Options.legacy_dot = false;
        Options.encoding = Charset.defaultCharset();
        Skeleton.readDefault();
    }

    public static void set_unused_warning(boolean unusedWarning) {
        if (unusedWarning) {
            Options.enable(ErrorMessages.MACRO_UNUSED);
        } else {
            Options.suppress(ErrorMessages.MACRO_UNUSED);
        }
    }

    public static void setSkeleton(File skel) {
        Skeleton.readSkelFile(skel);
    }

    public static void setDir(File d) {
        if (d.isFile()) {
            Out.error("Error: \"" + d + "\" is not a directory.");
            throw new GeneratorException();
        }
        if (!d.isDirectory() && !d.mkdirs()) {
            Out.error("Error: couldn't create directory \"" + d + "\"");
            throw new GeneratorException();
        }
        Options.directory = d;
    }

    public static void setDir(String dirName) {
        OptionUtils.setDir(new File(dirName));
    }

    public static void enableWarning(String warning) {
        try {
            ErrorMessages msg = ErrorMessages.valueOf(warning.toUpperCase().replace('-', '_'));
            Options.enable(msg);
        }
        catch (IllegalArgumentException e) {
            Out.error(ErrorMessages.UNKNOWN_WARNING, warning);
            throw new GeneratorException(e);
        }
    }

    public static void suppressWarning(String warning) {
        try {
            ErrorMessages msg = ErrorMessages.valueOf(warning.toUpperCase().replace('-', '_'));
            Options.suppress(msg);
        }
        catch (IllegalArgumentException e) {
            Out.error(ErrorMessages.UNKNOWN_WARNING, warning);
            throw new GeneratorException(e);
        }
    }

    public static void enableAllWarnings() {
        for (ErrorMessages msg : ErrorMessages.values()) {
            if (!ErrorMessages.isConfigurableWarning(msg)) continue;
            Options.enable(msg);
        }
    }

    public static void suppressAllWarnings() {
        for (ErrorMessages msg : ErrorMessages.values()) {
            if (!ErrorMessages.isConfigurableWarning(msg)) continue;
            Options.suppress(msg);
        }
    }
}

