// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicecontrol/v1/service_controller.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V1_INTERNAL_SERVICE_CONTROLLER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V1_INTERNAL_SERVICE_CONTROLLER_TRACING_CONNECTION_H

#include "google/cloud/servicecontrol/v1/service_controller_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicecontrol_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ServiceControllerTracingConnection
    : public servicecontrol_v1::ServiceControllerConnection {
 public:
  ~ServiceControllerTracingConnection() override = default;

  explicit ServiceControllerTracingConnection(
      std::shared_ptr<servicecontrol_v1::ServiceControllerConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::api::servicecontrol::v1::CheckResponse> Check(
      google::api::servicecontrol::v1::CheckRequest const& request) override;

  StatusOr<google::api::servicecontrol::v1::ReportResponse> Report(
      google::api::servicecontrol::v1::ReportRequest const& request) override;

 private:
  std::shared_ptr<servicecontrol_v1::ServiceControllerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<servicecontrol_v1::ServiceControllerConnection>
MakeServiceControllerTracingConnection(
    std::shared_ptr<servicecontrol_v1::ServiceControllerConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicecontrol_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V1_INTERNAL_SERVICE_CONTROLLER_TRACING_CONNECTION_H
