// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_RAPID_MIGRATION_ASSESSMENT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_RAPID_MIGRATION_ASSESSMENT_CLIENT_H

#include "google/cloud/rapidmigrationassessment/v1/rapid_migration_assessment_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class RapidMigrationAssessmentClient {
 public:
  explicit RapidMigrationAssessmentClient(
      std::shared_ptr<RapidMigrationAssessmentConnection> connection,
      Options opts = {});
  ~RapidMigrationAssessmentClient();

  ///@{
  /// @name Copy and move support
  RapidMigrationAssessmentClient(RapidMigrationAssessmentClient const&) =
      default;
  RapidMigrationAssessmentClient& operator=(
      RapidMigrationAssessmentClient const&) = default;
  RapidMigrationAssessmentClient(RapidMigrationAssessmentClient&&) = default;
  RapidMigrationAssessmentClient& operator=(RapidMigrationAssessmentClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(RapidMigrationAssessmentClient const& a,
                         RapidMigrationAssessmentClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(RapidMigrationAssessmentClient const& a,
                         RapidMigrationAssessmentClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Create a Collector to manage the on-prem appliance which collects
  /// information about Customer assets.
  ///
  /// @param parent  Required. Name of the parent (project+location).
  /// @param collector  Required. The resource being created.
  /// @param collector_id  Required. Id of the requesting object.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.CreateCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  CreateCollector(
      std::string const& parent,
      google::cloud::rapidmigrationassessment::v1::Collector const& collector,
      std::string const& collector_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCollector(
      NoAwaitTag, std::string const& parent,
      google::cloud::rapidmigrationassessment::v1::Collector const& collector,
      std::string const& collector_id, Options opts = {});

  // clang-format off
  ///
  /// Create a Collector to manage the on-prem appliance which collects
  /// information about Customer assets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.CreateCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.CreateCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  CreateCollector(
      google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  CreateCollector(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Creates an Annotation
  ///
  /// @param parent  Required. Name of the parent (project+location).
  /// @param annotation  Required. The resource being created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Annotation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Annotation]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L137}
  /// [google.cloud.rapidmigrationassessment.v1.CreateAnnotationRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L167}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
  CreateAnnotation(
      std::string const& parent,
      google::cloud::rapidmigrationassessment::v1::Annotation const& annotation,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAnnotation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAnnotation(
      NoAwaitTag, std::string const& parent,
      google::cloud::rapidmigrationassessment::v1::Annotation const& annotation,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an Annotation
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.CreateAnnotationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Annotation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Annotation]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L137}
  /// [google.cloud.rapidmigrationassessment.v1.CreateAnnotationRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L167}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
  CreateAnnotation(google::cloud::rapidmigrationassessment::v1::
                       CreateAnnotationRequest const& request,
                   Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAnnotation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAnnotation(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::
          CreateAnnotationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAnnotation
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
  CreateAnnotation(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Annotation.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.rapidmigrationassessment.v1.Annotation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Annotation]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L137}
  /// [google.cloud.rapidmigrationassessment.v1.GetAnnotationRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L184}
  ///
  // clang-format on
  StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
  GetAnnotation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Annotation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.GetAnnotationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.rapidmigrationassessment.v1.Annotation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Annotation]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L137}
  /// [google.cloud.rapidmigrationassessment.v1.GetAnnotationRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L184}
  ///
  // clang-format on
  StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
  GetAnnotation(
      google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Collectors in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListCollectorsRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.rapidmigrationassessment.v1.Collector], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.ListCollectorsRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L215}
  ///
  // clang-format on
  StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
  ListCollectors(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Collectors in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.ListCollectorsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.rapidmigrationassessment.v1.Collector], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.ListCollectorsRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L215}
  ///
  // clang-format on
  StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
  ListCollectors(
      google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Collector.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.rapidmigrationassessment.v1.Collector])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.GetCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L251}
  ///
  // clang-format on
  StatusOr<google::cloud::rapidmigrationassessment::v1::Collector> GetCollector(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Collector.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.GetCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.rapidmigrationassessment.v1.Collector])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.GetCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L251}
  ///
  // clang-format on
  StatusOr<google::cloud::rapidmigrationassessment::v1::Collector> GetCollector(
      google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Collector.
  ///
  /// @param collector  Required. The resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Collector resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.UpdateCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L288}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  UpdateCollector(
      google::cloud::rapidmigrationassessment::v1::Collector const& collector,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::Collector const& collector,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Collector.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.UpdateCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.UpdateCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L288}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  UpdateCollector(
      google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  UpdateCollector(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Collector - changes state of collector to "Deleting".
  /// Background jobs does final deletion thorugh producer api.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.DeleteCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L262}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  DeleteCollector(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCollector(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Collector - changes state of collector to "Deleting".
  /// Background jobs does final deletion thorugh producer api.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.DeleteCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.DeleteCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L262}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  DeleteCollector(
      google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  DeleteCollector(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Resumes the given collector.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.ResumeCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L317}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  ResumeCollector(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResumeCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResumeCollector(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Resumes the given collector.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.ResumeCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.ResumeCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L317}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  ResumeCollector(
      google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResumeCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResumeCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResumeCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  ResumeCollector(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Registers the given collector.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.RegisterCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L343}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  RegisterCollector(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RegisterCollector(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Registers the given collector.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.RegisterCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.RegisterCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L343}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  RegisterCollector(google::cloud::rapidmigrationassessment::v1::
                        RegisterCollectorRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RegisterCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::
          RegisterCollectorRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RegisterCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  RegisterCollector(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Pauses the given collector.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.PauseCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L369}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  PauseCollector(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief PauseCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PauseCollector(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Pauses the given collector.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.rapidmigrationassessment.v1.PauseCollectorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.rapidmigrationassessment.v1.Collector] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.rapidmigrationassessment.v1.Collector]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/api_entities.proto#L44}
  /// [google.cloud.rapidmigrationassessment.v1.PauseCollectorRequest]: @googleapis_reference_link{google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto#L369}
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  PauseCollector(
      google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PauseCollector
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PauseCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PauseCollector
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  PauseCollector(google::longrunning::Operation const& operation,
                 Options opts = {});

 private:
  std::shared_ptr<RapidMigrationAssessmentConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_RAPID_MIGRATION_ASSESSMENT_CLIENT_H
