// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/internal/subscriber_auth_decorator.h"
#include "google/cloud/internal/async_read_write_stream_auth.h"
#include <google/pubsub/v1/pubsub.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SubscriberAuth::SubscriberAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<SubscriberStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::pubsub::v1::Subscription> SubscriberAuth::CreateSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::Subscription const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::Subscription> SubscriberAuth::GetSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::GetSubscriptionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::Subscription> SubscriberAuth::UpdateSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::UpdateSubscriptionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::ListSubscriptionsResponse>
SubscriberAuth::ListSubscriptions(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListSubscriptionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListSubscriptions(context, options, request);
}

Status SubscriberAuth::DeleteSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DeleteSubscriptionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::PullResponse> SubscriberAuth::Pull(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::PullRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Pull(context, options, request);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::pubsub::v1::StreamingPullRequest,
    google::pubsub::v1::StreamingPullResponse>>
SubscriberAuth::AsyncStreamingPull(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using StreamAuth = google::cloud::internal::AsyncStreamingReadWriteRpcAuth<
      google::pubsub::v1::StreamingPullRequest,
      google::pubsub::v1::StreamingPullResponse>;

  auto call = [child = child_, cq, options = std::move(options)](
                  std::shared_ptr<grpc::ClientContext> ctx) {
    return child->AsyncStreamingPull(cq, std::move(ctx), options);
  };
  return std::make_unique<StreamAuth>(
      std::move(context), auth_, StreamAuth::StreamFactory(std::move(call)));
}

Status SubscriberAuth::ModifyPushConfig(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ModifyPushConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ModifyPushConfig(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberAuth::GetSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::GetSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::ListSnapshotsResponse>
SubscriberAuth::ListSnapshots(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListSnapshotsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListSnapshots(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberAuth::CreateSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::CreateSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberAuth::UpdateSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::UpdateSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSnapshot(context, options, request);
}

Status SubscriberAuth::DeleteSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DeleteSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::SeekResponse> SubscriberAuth::Seek(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::SeekRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Seek(context, options, request);
}

StatusOr<google::iam::v1::Policy> SubscriberAuth::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> SubscriberAuth::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SubscriberAuth::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, options, request);
}

future<Status> SubscriberAuth::AsyncModifyAckDeadline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::pubsub::v1::ModifyAckDeadlineRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncModifyAckDeadline(cq, *std::move(context),
                                             std::move(options), request);
      });
}

future<Status> SubscriberAuth::AsyncAcknowledge(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::pubsub::v1::AcknowledgeRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncAcknowledge(cq, *std::move(context),
                                       std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
