// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_H

#include "google/cloud/osconfig/v1/internal/os_config_zonal_retry_traits.h"
#include "google/cloud/osconfig/v1/os_config_zonal_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/osconfig/v1/osconfig_zonal_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `OsConfigZonalServiceConnection`.
class OsConfigZonalServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<OsConfigZonalServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `OsConfigZonalServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class OsConfigZonalServiceLimitedErrorCountRetryPolicy
    : public OsConfigZonalServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit OsConfigZonalServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  OsConfigZonalServiceLimitedErrorCountRetryPolicy(
      OsConfigZonalServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : OsConfigZonalServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  OsConfigZonalServiceLimitedErrorCountRetryPolicy(
      OsConfigZonalServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : OsConfigZonalServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<OsConfigZonalServiceRetryPolicy> clone() const override {
    return std::make_unique<OsConfigZonalServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = OsConfigZonalServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      osconfig_v1_internal::OsConfigZonalServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `OsConfigZonalServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class OsConfigZonalServiceLimitedTimeRetryPolicy
    : public OsConfigZonalServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit OsConfigZonalServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  OsConfigZonalServiceLimitedTimeRetryPolicy(
      OsConfigZonalServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : OsConfigZonalServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  OsConfigZonalServiceLimitedTimeRetryPolicy(
      OsConfigZonalServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : OsConfigZonalServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<OsConfigZonalServiceRetryPolicy> clone() const override {
    return std::make_unique<OsConfigZonalServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = OsConfigZonalServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      osconfig_v1_internal::OsConfigZonalServiceRetryTraits>
      impl_;
};

/**
 * The `OsConfigZonalServiceConnection` object for `OsConfigZonalServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `OsConfigZonalServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `OsConfigZonalServiceClient`.
 *
 * To create a concrete instance, see `MakeOsConfigZonalServiceConnection()`.
 *
 * For mocking, see `osconfig_v1_mocks::MockOsConfigZonalServiceConnection`.
 */
class OsConfigZonalServiceConnection {
 public:
  virtual ~OsConfigZonalServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateOSPolicyAssignment(
      NoAwaitTag,
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request);

  virtual future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateOSPolicyAssignment(
      NoAwaitTag,
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request);

  virtual future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
  GetOSPolicyAssignment(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request);

  virtual StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignments(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request);

  virtual StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignmentRevisions(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
          request);

  virtual future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteOSPolicyAssignment(
      NoAwaitTag,
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request);

  virtual future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  GetOSPolicyAssignmentReport(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
          request);

  virtual StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  ListOSPolicyAssignmentReports(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest
          request);

  virtual StatusOr<google::cloud::osconfig::v1::Inventory> GetInventory(
      google::cloud::osconfig::v1::GetInventoryRequest const& request);

  virtual StreamRange<google::cloud::osconfig::v1::Inventory> ListInventories(
      google::cloud::osconfig::v1::ListInventoriesRequest request);

  virtual StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
  GetVulnerabilityReport(
      google::cloud::osconfig::v1::GetVulnerabilityReportRequest const&
          request);

  virtual StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
  ListVulnerabilityReports(
      google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request);
};

/**
 * A factory function to construct an object of type
 * `OsConfigZonalServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * OsConfigZonalServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `OsConfigZonalServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::osconfig_v1::OsConfigZonalServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `OsConfigZonalServiceConnection`
 * created by this function.
 */
std::shared_ptr<OsConfigZonalServiceConnection>
MakeOsConfigZonalServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_H
