// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/internal/dep_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkservices/v1/dep.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DepServiceMetadata::DepServiceMetadata(
    std::shared_ptr<DepServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::networkservices::v1::ListLbTrafficExtensionsResponse>
DepServiceMetadata::ListLbTrafficExtensions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListLbTrafficExtensions(context, options, request);
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceMetadata::GetLbTrafficExtension(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLbTrafficExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncCreateLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateLbTrafficExtension(cq, std::move(context),
                                               std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::CreateLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateLbTrafficExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncUpdateLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  SetMetadata(
      *context, *options,
      absl::StrCat("lb_traffic_extension.name=",
                   internal::UrlEncode(request.lb_traffic_extension().name())));
  return child_->AsyncUpdateLbTrafficExtension(cq, std::move(context),
                                               std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::UpdateLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("lb_traffic_extension.name=",
                   internal::UrlEncode(request.lb_traffic_extension().name())));
  return child_->UpdateLbTrafficExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncDeleteLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteLbTrafficExtension(cq, std::move(context),
                                               std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::DeleteLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteLbTrafficExtension(context, options, request);
}

StatusOr<google::cloud::networkservices::v1::ListLbRouteExtensionsResponse>
DepServiceMetadata::ListLbRouteExtensions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListLbRouteExtensionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListLbRouteExtensions(context, options, request);
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceMetadata::GetLbRouteExtension(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLbRouteExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncCreateLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateLbRouteExtension(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::CreateLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateLbRouteExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncUpdateLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  SetMetadata(
      *context, *options,
      absl::StrCat("lb_route_extension.name=",
                   internal::UrlEncode(request.lb_route_extension().name())));
  return child_->AsyncUpdateLbRouteExtension(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::UpdateLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("lb_route_extension.name=",
                   internal::UrlEncode(request.lb_route_extension().name())));
  return child_->UpdateLbRouteExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncDeleteLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteLbRouteExtension(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DepServiceMetadata::DeleteLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteLbRouteExtension(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> DepServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void DepServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options,
                                     std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DepServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
