// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#include "google/cloud/networkconnectivity/v1/policy_based_routing_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyBasedRoutingServiceClient::PolicyBasedRoutingServiceClient(
    std::shared_ptr<PolicyBasedRoutingServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
PolicyBasedRoutingServiceClient::~PolicyBasedRoutingServiceClient() = default;

StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceClient::ListPolicyBasedRoutes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListPolicyBasedRoutes(request);
}

StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceClient::ListPolicyBasedRoutes(
    google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPolicyBasedRoutes(std::move(request));
}

StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceClient::GetPolicyBasedRoute(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest request;
  request.set_name(name);
  return connection_->GetPolicyBasedRoute(request);
}

StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceClient::GetPolicyBasedRoute(
    google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPolicyBasedRoute(request);
}

future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
PolicyBasedRoutingServiceClient::CreatePolicyBasedRoute(
    std::string const& parent,
    google::cloud::networkconnectivity::v1::PolicyBasedRoute const&
        policy_based_route,
    std::string const& policy_based_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest request;
  request.set_parent(parent);
  *request.mutable_policy_based_route() = policy_based_route;
  request.set_policy_based_route_id(policy_based_route_id);
  return connection_->CreatePolicyBasedRoute(request);
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceClient::CreatePolicyBasedRoute(
    NoAwaitTag, std::string const& parent,
    google::cloud::networkconnectivity::v1::PolicyBasedRoute const&
        policy_based_route,
    std::string const& policy_based_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest request;
  request.set_parent(parent);
  *request.mutable_policy_based_route() = policy_based_route;
  request.set_policy_based_route_id(policy_based_route_id);
  return connection_->CreatePolicyBasedRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
PolicyBasedRoutingServiceClient::CreatePolicyBasedRoute(
    google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePolicyBasedRoute(request);
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceClient::CreatePolicyBasedRoute(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePolicyBasedRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
PolicyBasedRoutingServiceClient::CreatePolicyBasedRoute(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePolicyBasedRoute(operation);
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
PolicyBasedRoutingServiceClient::DeletePolicyBasedRoute(std::string const& name,
                                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest request;
  request.set_name(name);
  return connection_->DeletePolicyBasedRoute(request);
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceClient::DeletePolicyBasedRoute(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest request;
  request.set_name(name);
  return connection_->DeletePolicyBasedRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
PolicyBasedRoutingServiceClient::DeletePolicyBasedRoute(
    google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePolicyBasedRoute(request);
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceClient::DeletePolicyBasedRoute(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePolicyBasedRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
PolicyBasedRoutingServiceClient::DeletePolicyBasedRoute(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePolicyBasedRoute(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1
}  // namespace cloud
}  // namespace google
