// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#include "google/cloud/dataproc/v1/internal/session_template_controller_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SessionTemplateControllerTracingStub::SessionTemplateControllerTracingStub(
    std::shared_ptr<SessionTemplateControllerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingStub::CreateSessionTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dataproc.v1.SessionTemplateController",
      "CreateSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateSessionTemplate(context, options, request));
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingStub::UpdateSessionTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dataproc.v1.SessionTemplateController",
      "UpdateSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateSessionTemplate(context, options, request));
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingStub::GetSessionTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::GetSessionTemplateRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dataproc.v1.SessionTemplateController",
      "GetSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetSessionTemplate(context, options, request));
}

StatusOr<google::cloud::dataproc::v1::ListSessionTemplatesResponse>
SessionTemplateControllerTracingStub::ListSessionTemplates(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::ListSessionTemplatesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dataproc.v1.SessionTemplateController",
      "ListSessionTemplates");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListSessionTemplates(context, options, request));
}

Status SessionTemplateControllerTracingStub::DeleteSessionTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dataproc.v1.SessionTemplateController",
      "DeleteSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteSessionTemplate(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SessionTemplateControllerStub>
MakeSessionTemplateControllerTracingStub(
    std::shared_ptr<SessionTemplateControllerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SessionTemplateControllerTracingStub>(
      std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
