// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

#include "google/cloud/datacatalog/lineage/v1/lineage_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datacatalog_lineage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LineageClient::LineageClient(std::shared_ptr<LineageConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
LineageClient::~LineageClient() = default;

StatusOr<
    google::cloud::datacatalog::lineage::v1::ProcessOpenLineageRunEventResponse>
LineageClient::ProcessOpenLineageRunEvent(
    std::string const& parent, google::protobuf::Struct const& open_lineage,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::ProcessOpenLineageRunEventRequest
      request;
  request.set_parent(parent);
  *request.mutable_open_lineage() = open_lineage;
  return connection_->ProcessOpenLineageRunEvent(request);
}

StatusOr<
    google::cloud::datacatalog::lineage::v1::ProcessOpenLineageRunEventResponse>
LineageClient::ProcessOpenLineageRunEvent(
    google::cloud::datacatalog::lineage::v1::
        ProcessOpenLineageRunEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ProcessOpenLineageRunEvent(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::CreateProcess(
    std::string const& parent,
    google::cloud::datacatalog::lineage::v1::Process const& process,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::CreateProcessRequest request;
  request.set_parent(parent);
  *request.mutable_process() = process;
  return connection_->CreateProcess(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::CreateProcess(
    google::cloud::datacatalog::lineage::v1::CreateProcessRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateProcess(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::UpdateProcess(
    google::cloud::datacatalog::lineage::v1::Process const& process,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::UpdateProcessRequest request;
  *request.mutable_process() = process;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateProcess(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::UpdateProcess(
    google::cloud::datacatalog::lineage::v1::UpdateProcessRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateProcess(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::GetProcess(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::GetProcessRequest request;
  request.set_name(name);
  return connection_->GetProcess(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::GetProcess(
    google::cloud::datacatalog::lineage::v1::GetProcessRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProcess(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::ListProcesses(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::ListProcessesRequest request;
  request.set_parent(parent);
  return connection_->ListProcesses(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Process>
LineageClient::ListProcesses(
    google::cloud::datacatalog::lineage::v1::ListProcessesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListProcesses(std::move(request));
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteProcess(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::DeleteProcessRequest request;
  request.set_name(name);
  return connection_->DeleteProcess(request);
}

StatusOr<google::longrunning::Operation> LineageClient::DeleteProcess(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::DeleteProcessRequest request;
  request.set_name(name);
  return connection_->DeleteProcess(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteProcess(
    google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcess(request);
}

StatusOr<google::longrunning::Operation> LineageClient::DeleteProcess(
    NoAwaitTag,
    google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcess(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteProcess(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcess(operation);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::CreateRun(
    std::string const& parent,
    google::cloud::datacatalog::lineage::v1::Run const& run, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::CreateRunRequest request;
  request.set_parent(parent);
  *request.mutable_run() = run;
  return connection_->CreateRun(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::CreateRun(
    google::cloud::datacatalog::lineage::v1::CreateRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRun(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::UpdateRun(
    google::cloud::datacatalog::lineage::v1::Run const& run,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::UpdateRunRequest request;
  *request.mutable_run() = run;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRun(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::UpdateRun(
    google::cloud::datacatalog::lineage::v1::UpdateRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRun(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::GetRun(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::GetRunRequest request;
  request.set_name(name);
  return connection_->GetRun(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run> LineageClient::GetRun(
    google::cloud::datacatalog::lineage::v1::GetRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRun(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Run>
LineageClient::ListRuns(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::ListRunsRequest request;
  request.set_parent(parent);
  return connection_->ListRuns(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Run>
LineageClient::ListRuns(
    google::cloud::datacatalog::lineage::v1::ListRunsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuns(std::move(request));
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteRun(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::DeleteRunRequest request;
  request.set_name(name);
  return connection_->DeleteRun(request);
}

StatusOr<google::longrunning::Operation> LineageClient::DeleteRun(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::DeleteRunRequest request;
  request.set_name(name);
  return connection_->DeleteRun(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteRun(
    google::cloud::datacatalog::lineage::v1::DeleteRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRun(request);
}

StatusOr<google::longrunning::Operation> LineageClient::DeleteRun(
    NoAwaitTag,
    google::cloud::datacatalog::lineage::v1::DeleteRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRun(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageClient::DeleteRun(google::longrunning::Operation const& operation,
                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRun(operation);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::CreateLineageEvent(
    std::string const& parent,
    google::cloud::datacatalog::lineage::v1::LineageEvent const& lineage_event,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::CreateLineageEventRequest request;
  request.set_parent(parent);
  *request.mutable_lineage_event() = lineage_event;
  return connection_->CreateLineageEvent(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::CreateLineageEvent(
    google::cloud::datacatalog::lineage::v1::CreateLineageEventRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLineageEvent(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::GetLineageEvent(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::GetLineageEventRequest request;
  request.set_name(name);
  return connection_->GetLineageEvent(request);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::GetLineageEvent(
    google::cloud::datacatalog::lineage::v1::GetLineageEventRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLineageEvent(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::ListLineageEvents(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::ListLineageEventsRequest request;
  request.set_parent(parent);
  return connection_->ListLineageEvents(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageClient::ListLineageEvents(
    google::cloud::datacatalog::lineage::v1::ListLineageEventsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLineageEvents(std::move(request));
}

Status LineageClient::DeleteLineageEvent(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::lineage::v1::DeleteLineageEventRequest request;
  request.set_name(name);
  return connection_->DeleteLineageEvent(request);
}

Status LineageClient::DeleteLineageEvent(
    google::cloud::datacatalog::lineage::v1::DeleteLineageEventRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLineageEvent(request);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Link>
LineageClient::SearchLinks(
    google::cloud::datacatalog::lineage::v1::SearchLinksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchLinks(std::move(request));
}

StreamRange<google::cloud::datacatalog::lineage::v1::ProcessLinks>
LineageClient::BatchSearchLinkProcesses(
    google::cloud::datacatalog::lineage::v1::BatchSearchLinkProcessesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchSearchLinkProcesses(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_lineage_v1
}  // namespace cloud
}  // namespace google
