// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_ROUTINE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_ROUTINE_CONNECTION_H

#include "google/cloud/bigquerycontrol/v2/internal/routine_retry_traits.h"
#include "google/cloud/bigquerycontrol/v2/routine_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/v2/routine.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `RoutineServiceConnection`.
class RoutineServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<RoutineServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `RoutineServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RoutineServiceLimitedErrorCountRetryPolicy
    : public RoutineServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit RoutineServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  RoutineServiceLimitedErrorCountRetryPolicy(
      RoutineServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : RoutineServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  RoutineServiceLimitedErrorCountRetryPolicy(
      RoutineServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : RoutineServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RoutineServiceRetryPolicy> clone() const override {
    return std::make_unique<RoutineServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RoutineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      bigquerycontrol_v2_internal::RoutineServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `RoutineServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RoutineServiceLimitedTimeRetryPolicy : public RoutineServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit RoutineServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  RoutineServiceLimitedTimeRetryPolicy(
      RoutineServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : RoutineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  RoutineServiceLimitedTimeRetryPolicy(
      RoutineServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : RoutineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RoutineServiceRetryPolicy> clone() const override {
    return std::make_unique<RoutineServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RoutineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      bigquerycontrol_v2_internal::RoutineServiceRetryTraits>
      impl_;
};

/**
 * The `RoutineServiceConnection` object for `RoutineServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `RoutineServiceClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `RoutineServiceClient`.
 *
 * To create a concrete instance, see `MakeRoutineServiceConnection()`.
 *
 * For mocking, see `bigquerycontrol_v2_mocks::MockRoutineServiceConnection`.
 */
class RoutineServiceConnection {
 public:
  virtual ~RoutineServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::bigquery::v2::Routine> GetRoutine(
      google::cloud::bigquery::v2::GetRoutineRequest const& request);

  virtual StatusOr<google::cloud::bigquery::v2::Routine> InsertRoutine(
      google::cloud::bigquery::v2::InsertRoutineRequest const& request);

  virtual StatusOr<google::cloud::bigquery::v2::Routine> UpdateRoutine(
      google::cloud::bigquery::v2::UpdateRoutineRequest const& request);

  virtual StatusOr<google::cloud::bigquery::v2::Routine> PatchRoutine(
      google::cloud::bigquery::v2::PatchRoutineRequest const& request);

  virtual Status DeleteRoutine(
      google::cloud::bigquery::v2::DeleteRoutineRequest const& request);

  virtual StatusOr<google::cloud::bigquery::v2::ListRoutinesResponse>
  ListRoutines(google::cloud::bigquery::v2::ListRoutinesRequest const& request);
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_ROUTINE_CONNECTION_H
