// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_INSTANCES_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_INSTANCES_CONNECTION_IMPL_H

#include "google/cloud/appengine/v1/instances_connection.h"
#include "google/cloud/appengine/v1/instances_connection_idempotency_policy.h"
#include "google/cloud/appengine/v1/instances_options.h"
#include "google/cloud/appengine/v1/internal/instances_retry_traits.h"
#include "google/cloud/appengine/v1/internal/instances_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class InstancesConnectionImpl : public appengine_v1::InstancesConnection {
 public:
  ~InstancesConnectionImpl() override = default;

  InstancesConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<appengine_v1_internal::InstancesStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::appengine::v1::Instance> ListInstances(
      google::appengine::v1::ListInstancesRequest request) override;

  StatusOr<google::appengine::v1::Instance> GetInstance(
      google::appengine::v1::GetInstanceRequest const& request) override;

  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteInstance(
      google::appengine::v1::DeleteInstanceRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::appengine::v1::DeleteInstanceRequest const& request) override;

  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::appengine::v1::Instance>> DebugInstance(
      google::appengine::v1::DebugInstanceRequest const& request) override;

  StatusOr<google::longrunning::Operation> DebugInstance(
      NoAwaitTag,
      google::appengine::v1::DebugInstanceRequest const& request) override;

  future<StatusOr<google::appengine::v1::Instance>> DebugInstance(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<appengine_v1_internal::InstancesStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_INSTANCES_CONNECTION_IMPL_H
