// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTERNAL_REQUEST_ID_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTERNAL_REQUEST_ID_H

#include <google/protobuf/descriptor.h>
#include <yaml-cpp/yaml.h>
#include <string>

namespace google {
namespace cloud {
namespace generator_internal {

/// Determine if a field is a request_id-like field.
bool MeetsRequestIdRequirements(
    google::protobuf::FieldDescriptor const& descriptor);

/// Returns the name of the (first) request_id-like field in the request
/// message.
std::string RequestIdFieldName(
    YAML::Node const& service_config,
    google::protobuf::MethodDescriptor const& descriptor);

}  // namespace generator_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTERNAL_REQUEST_ID_H
