package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountMockRule invokes the edas.GetAccountMockRule API synchronously
func (client *Client) GetAccountMockRule(request *GetAccountMockRuleRequest) (response *GetAccountMockRuleResponse, err error) {
	response = CreateGetAccountMockRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountMockRuleWithChan invokes the edas.GetAccountMockRule API asynchronously
func (client *Client) GetAccountMockRuleWithChan(request *GetAccountMockRuleRequest) (<-chan *GetAccountMockRuleResponse, <-chan error) {
	responseChan := make(chan *GetAccountMockRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountMockRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountMockRuleWithCallback invokes the edas.GetAccountMockRule API asynchronously
func (client *Client) GetAccountMockRuleWithCallback(request *GetAccountMockRuleRequest, callback func(response *GetAccountMockRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountMockRuleResponse
		var err error
		defer close(result)
		response, err = client.GetAccountMockRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountMockRuleRequest is the request struct for api GetAccountMockRule
type GetAccountMockRuleRequest struct {
	*requests.RoaRequest
	ProviderAppName string           `position:"Query" name:"ProviderAppName"`
	PageNumber      string           `position:"Query" name:"PageNumber"`
	PageSize        string           `position:"Query" name:"PageSize"`
	Name            string           `position:"Query" name:"Name"`
	Namespace       string           `position:"Query" name:"Namespace"`
	MockType        requests.Integer `position:"Query" name:"MockType"`
	Region          string           `position:"Query" name:"Region"`
	ConsumerAppName string           `position:"Query" name:"ConsumerAppName"`
}

// GetAccountMockRuleResponse is the response struct for api GetAccountMockRule
type GetAccountMockRuleResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Success bool   `json:"Success" xml:"Success"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateGetAccountMockRuleRequest creates a request to invoke GetAccountMockRule API
func CreateGetAccountMockRuleRequest() (request *GetAccountMockRuleRequest) {
	request = &GetAccountMockRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetAccountMockRule", "/pop/sp/api/mock/getAccountMockRule", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccountMockRuleResponse creates a response to parse from GetAccountMockRule response
func CreateGetAccountMockRuleResponse() (response *GetAccountMockRuleResponse) {
	response = &GetAccountMockRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
