package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AliyunRegisterApAsset invokes the cloudwf.AliyunRegisterApAsset API synchronously
// api document: https://help.aliyun.com/api/cloudwf/aliyunregisterapasset.html
func (client *Client) AliyunRegisterApAsset(request *AliyunRegisterApAssetRequest) (response *AliyunRegisterApAssetResponse, err error) {
	response = CreateAliyunRegisterApAssetResponse()
	err = client.DoAction(request, response)
	return
}

// AliyunRegisterApAssetWithChan invokes the cloudwf.AliyunRegisterApAsset API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/aliyunregisterapasset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AliyunRegisterApAssetWithChan(request *AliyunRegisterApAssetRequest) (<-chan *AliyunRegisterApAssetResponse, <-chan error) {
	responseChan := make(chan *AliyunRegisterApAssetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AliyunRegisterApAsset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AliyunRegisterApAssetWithCallback invokes the cloudwf.AliyunRegisterApAsset API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/aliyunregisterapasset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AliyunRegisterApAssetWithCallback(request *AliyunRegisterApAssetRequest, callback func(response *AliyunRegisterApAssetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AliyunRegisterApAssetResponse
		var err error
		defer close(result)
		response, err = client.AliyunRegisterApAsset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AliyunRegisterApAssetRequest is the request struct for api AliyunRegisterApAsset
type AliyunRegisterApAssetRequest struct {
	*requests.RpcRequest
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
	Mac       string           `position:"Query" name:"Mac"`
	SerialNo  string           `position:"Query" name:"SerialNo"`
}

// AliyunRegisterApAssetResponse is the response struct for api AliyunRegisterApAsset
type AliyunRegisterApAssetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateAliyunRegisterApAssetRequest creates a request to invoke AliyunRegisterApAsset API
func CreateAliyunRegisterApAssetRequest() (request *AliyunRegisterApAssetRequest) {
	request = &AliyunRegisterApAssetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "AliyunRegisterApAsset", "cloudwf", "openAPI")
	return
}

// CreateAliyunRegisterApAssetResponse creates a response to parse from AliyunRegisterApAsset response
func CreateAliyunRegisterApAssetResponse() (response *AliyunRegisterApAssetResponse) {
	response = &AliyunRegisterApAssetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
